package ru.yandex.direct.core.aggregatedstatuses.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.adgroup.aggrstatus.AggregatedStatusAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.StatusBLGenerated;
import ru.yandex.direct.core.entity.adgroup.model.StatusModerate;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;
import ru.yandex.direct.core.entity.aggregatedstatuses.ad.AdStatesEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AdGroupCounters;
import ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AdGroupStatesEnum;

import static ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AdGroupStatesEnum.STATUS_BL_GENERATED_NOTHING_GENERATED;
import static ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AdGroupStatesEnum.STATUS_BL_GENERATED_PROCESSING;

public class AdGroupStates implements StatesCalculator<AggregatedStatusAdGroup, AdGroupStatesEnum> {
    private final List<StatusModerate> moderationStates = List.of(
            StatusModerate.READY, StatusModerate.SENDING, StatusModerate.SENT);

    @Override
    public Collection<AdGroupStatesEnum> calc(AggregatedStatusAdGroup adgroup) {
        List<AdGroupStatesEnum> states = new ArrayList<>();
        if (StatusModerate.NO.equals(adgroup.getStatusModerate())) {
            states.add(AdGroupStatesEnum.REJECTED);
        } else if (StatusModerate.NEW.equals(adgroup.getStatusModerate())) {
            states.add(AdGroupStatesEnum.DRAFT);
        } else if (moderationStates.contains(adgroup.getStatusModerate())) {
            states.add(AdGroupStatesEnum.MODERATION);
        }

        // DIRECT-62527
        Set<AdGroupType> dynamicAndSmartAdGroupTypes = Set.of(AdGroupType.DYNAMIC, AdGroupType.PERFORMANCE);
        if (Boolean.TRUE.equals(adgroup.getBsRarelyLoaded()) && !dynamicAndSmartAdGroupTypes.contains(adgroup.getType())) {
            states.add(AdGroupStatesEnum.BS_RARELY_SERVED);
        }

        if (dynamicAndSmartAdGroupTypes.contains(adgroup.getType())){
            if(StatusBLGenerated.PROCESSING.equals(adgroup.getStatusBlGenerated())) {
                states.add(STATUS_BL_GENERATED_PROCESSING);
            } else if (StatusBLGenerated.NO.equals(adgroup.getStatusBlGenerated())) {
                states.add(STATUS_BL_GENERATED_NOTHING_GENERATED);
            }
        }

        List<Long> effectiveGeo = adgroup.getEffectiveGeo();
        if (effectiveGeo != null) {
            if (effectiveGeo.isEmpty()) {
                states.add(AdGroupStatesEnum.HAS_NO_EFFECTIVE_GEO);
            } else if (!effectiveGeo.equals(adgroup.getGeo())) {
                states.add(AdGroupStatesEnum.HAS_RESTRICTED_GEO);
            }
        }

        return states;
    }

    public Collection<AdGroupStatesEnum> calcByStatusAndCounters(SelfStatus status, AdGroupCounters counters) {
        List<AdGroupStatesEnum> states = new ArrayList<>();

        boolean hasAdsDraftOnModeration = counters.getAdStates()
                .getOrDefault(AdStatesEnum.DRAFT_ON_MODERATION, 0) > 0;
        if (GdSelfStatusEnum.DRAFT.equals(status.getStatus()) && hasAdsDraftOnModeration) {
            states.add(AdGroupStatesEnum.HAS_DRAFT_ON_MODERATION_ADS);
        }
        return states;
    }
}
