package ru.yandex.direct.core.aggregatedstatuses.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;
import ru.yandex.direct.core.entity.aggregatedstatuses.ad.AdStatesEnum;
import ru.yandex.direct.core.entity.banner.aggrstatus.StatusAggregationBanner;
import ru.yandex.direct.core.entity.banner.model.BannerButtonStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerDisplayHrefStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerFlags;
import ru.yandex.direct.core.entity.banner.model.BannerLogoStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerMulticardSetStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusSitelinksModerate;
import ru.yandex.direct.core.entity.banner.model.BannerTurboLandingStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerVcardStatusModerate;
import ru.yandex.direct.core.entity.banner.model.ModerateBannerPage;
import ru.yandex.direct.core.entity.banner.model.NewStatusImageModerate;
import ru.yandex.direct.core.entity.banner.model.StatusBannerImageModerate;
import ru.yandex.direct.core.entity.banner.model.StatusModerateBannerPage;
import ru.yandex.direct.core.entity.banner.model.StatusModerateOperator;
import ru.yandex.direct.core.entity.internalads.Constants;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class AdStates implements StatesCalculator<StatusAggregationBanner, AdStatesEnum> {
    private static final Set<BannerStatusModerate> ON_MODERATION_STATUSES = Set.of(
            BannerStatusModerate.READY, BannerStatusModerate.SENT, BannerStatusModerate.SENDING);
    private static final Set<NewStatusImageModerate> IMAGE_AD_ON_MODERATION_STATUSES = Set.of(
            NewStatusImageModerate.READY, NewStatusImageModerate.SENT, NewStatusImageModerate.SENDING);
    // Связка объявление-креатив
    private static final Set<BannerCreativeStatusModerate> BANNER_CREATIVE_ON_MODERATION_STATUSES = Set.of(
            BannerCreativeStatusModerate.READY,
            BannerCreativeStatusModerate.SENT,
            BannerCreativeStatusModerate.SENDING);
    // Сам креатив
    private static final Set<ru.yandex.direct.core.entity.creative.model.StatusModerate>
            CREATIVE_ON_MODERATION_STATUSES = Set.of(
            ru.yandex.direct.core.entity.creative.model.StatusModerate.READY,
            ru.yandex.direct.core.entity.creative.model.StatusModerate.SENT,
            ru.yandex.direct.core.entity.creative.model.StatusModerate.SENDING);

    private static final ru.yandex.direct.core.entity.creative.model.StatusModerate CREATIVE_STATUS_REJECTED =
            ru.yandex.direct.core.entity.creative.model.StatusModerate.NO;

    public static final List<BannerVcardStatusModerate> PHONE_FLAG_ON_MODERATION_STATUSES = List.of(
            BannerVcardStatusModerate.READY,
            BannerVcardStatusModerate.SENDING,
            BannerVcardStatusModerate.SENT);
    public static final List<BannerStatusSitelinksModerate> SITELINKS_ON_MODERATION_STATUSES = List.of(
            BannerStatusSitelinksModerate.READY, BannerStatusSitelinksModerate.SENDING,
            BannerStatusSitelinksModerate.SENT);
    public static final List<StatusBannerImageModerate> BANNER_IMAGE_ON_MODERATION_STATUSES =
            List.of(StatusBannerImageModerate.READY,
                    StatusBannerImageModerate.SENDING, StatusBannerImageModerate.SENT);
    public static final List<BannerDisplayHrefStatusModerate> DISPLAY_HREF_ON_MODERATION_STATUSES =
            List.of(BannerDisplayHrefStatusModerate.READY,
                    BannerDisplayHrefStatusModerate.SENDING, BannerDisplayHrefStatusModerate.SENT);
    public static final List<BannerTurboLandingStatusModerate> TURBO_LANDING_ON_MODERATION_STATUSES = List.of(
            BannerTurboLandingStatusModerate.READY, BannerTurboLandingStatusModerate.SENDING,
            BannerTurboLandingStatusModerate.SENT);
    public static final List<BannerCreativeStatusModerate> VIDEO_ADDITION_ON_MODERATION_STATUSES =
            List.of(BannerCreativeStatusModerate.READY,
                    BannerCreativeStatusModerate.SENDING, BannerCreativeStatusModerate.SENT);
    public static final List<BannerLogoStatusModerate> BANNER_LOGO_ON_MODERATION_STATUSES =
            List.of(BannerLogoStatusModerate.READY,
                    BannerLogoStatusModerate.SENDING, BannerLogoStatusModerate.SENT);
    public static final List<BannerButtonStatusModerate> BANNER_BUTTON_ON_MODERATION_STATUSES =
            List.of(BannerButtonStatusModerate.READY,
                    BannerButtonStatusModerate.SENDING, BannerButtonStatusModerate.SENT);
    public static final List<BannerMulticardSetStatusModerate> BANNER_MULTICARD_SET_ON_MODERATION_STATUSES =
            List.of(BannerMulticardSetStatusModerate.READY,
                    BannerMulticardSetStatusModerate.SENDING, BannerMulticardSetStatusModerate.SENT);

    private boolean isReadyToBs(StatusAggregationBanner ad) {
        final var bannerType = ad.getBannerType();
        final var statusShow = ad.getStatusShow();
        final var pagesModeration = ad.getPagesModeration();

        // Сайтлинки должны быть промодерированы или отсутствовать
        final var hasAcceptedSitelinks = !nvl(ad.getHasSitelinks(), false)
                || ad.getBannerSitelinksStatusModerate() == BannerStatusSitelinksModerate.YES;

        final var hasAcceptedTurbolanding = nvl(ad.getHasTurbolanding(), false)
                && ad.getBannerTurbolandingStatusModerate() == BannerTurboLandingStatusModerate.YES;

        final var hasAcceptedVcard = nvl(ad.getHasVCard(), false)
                && ad.getPhoneFlag() == BannerVcardStatusModerate.YES;

        final var hasAcceptedHref = nvl(ad.getBannerHasHref(), false)
                && nvl(ad.getBannerDisplayHrefStatusModerate(), BannerDisplayHrefStatusModerate.YES) == BannerDisplayHrefStatusModerate.YES;

        final var isTextBannerWithBusiness = nvl(ad.getHasPublishedOrganization(), false);
        final var isAcceptedImageBanner = ad.getBannerImageAdStatusModerate() == NewStatusImageModerate.YES;
        final var isAcceptedBannerBasedOnCreative = ad.getBannerBasedOnCreativeStatusModerate() == BannerCreativeStatusModerate.YES;
        final var isAcceptedTextBanner = bannerType == BannersBannerType.text
                && ad.getCampaignType() == CampaignsType.text
                && (hasAcceptedHref || hasAcceptedTurbolanding || hasAcceptedVcard || isTextBannerWithBusiness);

        final var hasAcceptedPagesModeration = pagesModeration != null
                && !pagesModeration.isEmpty()
                && pagesModeration.stream().anyMatch(pm -> pm.getStatusModerate() == StatusModerateBannerPage.YES);

        final var isCpmOutdoorAcceptedBanner = bannerType == BannersBannerType.cpm_outdoor
                && hasAcceptedPagesModeration;

        final var isAcceptedBanner = isAcceptedTextBanner
                || isAcceptedImageBanner
                || isAcceptedBannerBasedOnCreative
                || isCpmOutdoorAcceptedBanner
                || bannerType != null && List.of(BannersBannerType.dynamic, BannersBannerType.mobile_content, BannersBannerType.performance, BannersBannerType.internal, BannersBannerType.cpm_indoor).contains(bannerType)
                || bannerType != null && List.of(BannersBannerType.image_ad, BannersBannerType.cpc_video).contains(bannerType) && ad.getCampaignType() == CampaignsType.mobile_content;

        return ad.getStatusPostModerate() == BannerStatusPostModerate.YES
                && hasAcceptedSitelinks
                && isAcceptedBanner
                && (statusShow == null || statusShow);
    }

    @Override
    public Collection<AdStatesEnum> calc(StatusAggregationBanner ad) {
        List<AdStatesEnum> states = new ArrayList<>();
        if (nvl(ad.getStatusArchived(), false)) {
            states.add(AdStatesEnum.ARCHIVED);
        }
        if (!nvl(ad.getStatusShow(), true)) {
            if (BannersBannerType.internal == ad.getBannerType()
                    && nvl(ad.getInternalBannerStoppedByUrlMonitoring(), false)) {
                states.add(AdStatesEnum.SUSPENDED_BY_MONITORING);
            } else {
                states.add(AdStatesEnum.SUSPENDED);
            }
        }
        if (nvl(ad.getStatusActive(), false)) {
            states.add(AdStatesEnum.ACTIVE_IN_BS);
        }
        if (ad.getFlags() != null) {
            if (nvl(ad.getFlags().get(BannerFlags.SOCIAL_ADVERTISING), false)) {
                states.add(AdStatesEnum.HAS_SOCIAL_ADVERTISING_FLAG);
            }
            if (nvl(ad.getFlags().get(BannerFlags.ASOCIAL), false)) {
                states.add(AdStatesEnum.HAS_ASOCIAL_FLAG);
            }
            if (nvl(ad.getFlags().get(BannerFlags.UNFAMILY), false)) {
                states.add(AdStatesEnum.HAS_UNFAMILY_FLAG);
            }
            if (nvl(ad.getFlags().get(BannerFlags.TRAGIC), false)) {
                states.add(AdStatesEnum.HAS_TRAGIC_FLAG);
            }
        }

        boolean hrefMissed = !nvl(ad.getBannerHasHref(), true);

        var bannerType = ad.getBannerType();

        // Модерация
        var imageAdStatusModerate = ad.getBannerImageAdStatusModerate();
        // статус самого креатива perf_creatives.statusModerate
        var creativeStatusModerate = ad.getCreativeStatusModerate();
        // устаревший ли креатив (DIRECT-148277)
        var creativeStatusObsolete = ad.getCreativeStatusObsolete();
        // статус модерации связки объявление-креатив (banners_performance.statusModerate)
        var bannerCreativeStatusModerate = ad.getBannerBasedOnCreativeStatusModerate();
        var statusModerate = ad.getStatusModerate();
        boolean creativeRejected = CREATIVE_STATUS_REJECTED.equals(creativeStatusModerate);

        if (Boolean.TRUE.equals(creativeStatusObsolete)) {
            states.add(AdStatesEnum.OBSOLETE);
        }

        if (BannerStatusModerate.NEW.equals(statusModerate)
                || NewStatusImageModerate.NEW.equals(imageAdStatusModerate)) {
            states.add(AdStatesEnum.DRAFT);
        } else if (BannerStatusModerate.NO.equals(statusModerate)
                || BannerStatusPostModerate.REJECTED.equals(ad.getStatusPostModerate())
                || BannerCreativeStatusModerate.NO.equals(bannerCreativeStatusModerate)
                || NewStatusImageModerate.NO.equals(imageAdStatusModerate)
                || (BannersBannerType.performance.equals(bannerType) && creativeRejected)
                || (hrefMissed && BannerVcardStatusModerate.NO.equals(ad.getPhoneFlag()))) {
            states.add(AdStatesEnum.REJECTED);
        }

        if (BannersBannerType.text.equals(bannerType)
                && BannerCreativeStatusModerate.NO.equals(ad.getVideoAdditionsStatusModerate())) {
            states.add(AdStatesEnum.REJECTED_VIDEO_ADDITION);
        }

        if (has(IMAGE_AD_ON_MODERATION_STATUSES, imageAdStatusModerate)
                || has(CREATIVE_ON_MODERATION_STATUSES, creativeStatusModerate)
                || has(BANNER_CREATIVE_ON_MODERATION_STATUSES, bannerCreativeStatusModerate)
                || has(ON_MODERATION_STATUSES, statusModerate)
        ) {
            states.add(AdStatesEnum.MODERATION);
        }

        if (BannerStatusPostModerate.YES.equals(ad.getStatusPostModerate())) {
            states.add(AdStatesEnum.PREACCEPTED);
        }

        if (creativeRejected && !states.contains(AdStatesEnum.REJECTED)) {
            states.add(AdStatesEnum.CREATIVE_REJECTED);
        }

        if (nvl(ad.getAdditionsCalloutsDeclined(), false)) {
            states.add(AdStatesEnum.HAS_REJECTED_CALLOUTS);
        }

        if (BannerVcardStatusModerate.NO.equals(ad.getPhoneFlag())) {
            states.add(AdStatesEnum.REJECTED_VCARD);
        }

        if (BannerStatusSitelinksModerate.NO.equals(ad.getBannerSitelinksStatusModerate())) {
            states.add(AdStatesEnum.HAS_REJECTED_SITELINKS);
        }

        if (BannerLogoStatusModerate.NO.equals(ad.getBannerLogoStatusModerate())) {
            states.add(AdStatesEnum.REJECTED_LOGO);
        }

        if (BannerButtonStatusModerate.NO.equals(ad.getBannerButtonStatusModerate())) {
            states.add(AdStatesEnum.REJECTED_BUTTON);
        }

        if (BannerMulticardSetStatusModerate.NO.equals(ad.getBannerMulticardSetStatusModerate())) {
            states.add(AdStatesEnum.REJECTED_MULTICARD_SET);
        }

        if (StatusBannerImageModerate.NO.equals(ad.getBannerImageStatusModerate())) {
            states.add(AdStatesEnum.REJECTED_IMAGE);
        }

        if (BannerDisplayHrefStatusModerate.NO.equals(ad.getBannerDisplayHrefStatusModerate())) {
            states.add(AdStatesEnum.REJECTED_DISPLAY_HREF);
        }

        if (BannerTurboLandingStatusModerate.NO.equals(ad.getBannerTurbolandingStatusModerate())) {
            states.add(AdStatesEnum.REJECTED_TURBOLANDING);
        }

        if (nvl(ad.getAdditionsCalloutsOnModeration(), false)) {
            states.add(AdStatesEnum.CALLOUTS_ON_MODERATION);
        }

        if (ad.getPhoneFlag() != null && PHONE_FLAG_ON_MODERATION_STATUSES.contains(ad.getPhoneFlag())) {
            states.add(AdStatesEnum.VCARD_ON_MODERATION);
        }

        if (ad.getBannerSitelinksStatusModerate() != null
                && SITELINKS_ON_MODERATION_STATUSES.contains(ad.getBannerSitelinksStatusModerate())) {
            states.add(AdStatesEnum.SITELINKS_ON_MODERATION);
        }

        if (ad.getBannerLogoStatusModerate() != null
                && BANNER_LOGO_ON_MODERATION_STATUSES.contains(ad.getBannerLogoStatusModerate())) {
            states.add(AdStatesEnum.LOGO_ON_MODERATION);
        }

        if (ad.getBannerButtonStatusModerate() != null
                && BANNER_BUTTON_ON_MODERATION_STATUSES.contains(ad.getBannerButtonStatusModerate())) {
            states.add(AdStatesEnum.BUTTON_ON_MODERATION);
        }

        if (ad.getBannerMulticardSetStatusModerate() != null
                && BANNER_MULTICARD_SET_ON_MODERATION_STATUSES.contains(ad.getBannerMulticardSetStatusModerate())) {
            states.add(AdStatesEnum.MULTICARD_SET_ON_MODERATION);
        }

        if (ad.getBannerImageStatusModerate() != null
                && BANNER_IMAGE_ON_MODERATION_STATUSES.contains(ad.getBannerImageStatusModerate())) {
            states.add(AdStatesEnum.IMAGE_ON_MODERATION);
        }

        if (ad.getBannerDisplayHrefStatusModerate() != null
                && DISPLAY_HREF_ON_MODERATION_STATUSES.contains(ad.getBannerDisplayHrefStatusModerate())) {
            states.add(AdStatesEnum.DISPLAY_HREF_ON_MODERATION);
        }

        if (ad.getBannerTurbolandingStatusModerate() != null
                && TURBO_LANDING_ON_MODERATION_STATUSES.contains(ad.getBannerTurbolandingStatusModerate())) {
            states.add(AdStatesEnum.TURBOLANDING_ON_MODERATION);
        }

        if (BannersBannerType.text.equals(bannerType)
                && ad.getVideoAdditionsStatusModerate() != null
                && VIDEO_ADDITION_ON_MODERATION_STATUSES.contains(ad.getVideoAdditionsStatusModerate())) {
            states.add(AdStatesEnum.VIDEO_ADDITION_ON_MODERATION);
        }

        if (BannersBannerType.cpm_outdoor.equals(bannerType)) {
            if (ad.getPagesModeration() != null && !ad.getPagesModeration().isEmpty()) {
                states.addAll(statesByPagesModeration(ad.getPagesModeration()));
            } else {
                states.add(AdStatesEnum.PLACEMENTS_REQUIRED);
            }
        }

        final var templateId = ad.getTemplateId();
        final var isInternalAd = ad.getBannerType() == BannersBannerType.internal;
        final var adDontHaveTemplateOrItHasModeratedTemplate = templateId == null
                || Constants.isModeratedTemplate(templateId);

        if ((!isInternalAd || adDontHaveTemplateOrItHasModeratedTemplate) && isReadyToBs(ad)) {
            states.add(AdStatesEnum.READY_TO_BS);
        }

        return states;
    }

    /*
     * см. https://st.yandex-team.ru/DIRECT-106312#5dd2b6657016656205f71711
     */
    List<AdStatesEnum> statesByPagesModeration(List<ModerateBannerPage> pagesList) {
        int total = pagesList.size();
        int rejectedCount = 0;
        int acceptedCount = 0;
        int onModerationCount = 0;
        int activationCount = 0;

        for (ModerateBannerPage page : pagesList) { // на стримах может быть менее эффективно, а вызваем часто
            AdPageModerationStatus status = pageModerationStatus(page);
            if (AdPageModerationStatus.REJECTED.equals(status)) {
                rejectedCount++;
            } else if (AdPageModerationStatus.ACCEPTED.equals(status)) {
                acceptedCount++;
            } else if (AdPageModerationStatus.ACTIVATING.equals(status)) {
                activationCount++;
            } else if (AdPageModerationStatus.ON_MODERATION.equals(status)) {
                onModerationCount++;
            }
        }

        if (rejectedCount == total) {
            return Collections.singletonList(AdStatesEnum.ALL_PLACEMENTS_REJECTED);
        }

        List<AdStatesEnum> states = new ArrayList<>();
        if (rejectedCount > 0) {
            states.add(AdStatesEnum.HAS_REJECTED_PLACEMENTS);
        }

        if (acceptedCount > 0) {
            states.add(AdStatesEnum.HAS_ACCEPTED_PLACEMENTS);
        }

        if (onModerationCount > 0) {
            states.add(AdStatesEnum.HAS_PLACEMENTS_ON_MODERATION);
        }

        if (activationCount > 0) {
            states.add(AdStatesEnum.HAS_PLACEMENTS_ON_OPERATOR_ACTIVATION);
        }

        return states;
    }

    // иногда нужно добавить на баннер стейт зависящий от статуса баннера и его стейтов, чтобы учесть это уровнем
    // выше на группе, где по этому стейту будет счетчик
    public List<AdStatesEnum> calcStatesByStatus(SelfStatus status, Collection<AdStatesEnum> states) {
        List<AdStatesEnum> complexStates = new ArrayList<>();
        List<AdStatesEnum> modStates = List.of(
                AdStatesEnum.MODERATION, AdStatesEnum.HAS_PLACEMENTS_ON_MODERATION);
        if (GdSelfStatusEnum.DRAFT.equals(status.getStatus()) && CollectionUtils.containsAny(modStates, states)) {
            complexStates.add(AdStatesEnum.DRAFT_ON_MODERATION);
        }
        return complexStates;
    }

    private AdPageModerationStatus pageModerationStatus(ModerateBannerPage page) {
        var statusModerate = page.getStatusModerate();
        var statusModerateOperator = page.getStatusModerateOperator();
        boolean opYes = StatusModerateOperator.YES.equals(statusModerateOperator);
        if (StatusModerateBannerPage.YES.equals(statusModerate) && opYes) {
            return AdPageModerationStatus.ACCEPTED;
        } else if (StatusModerateBannerPage.YES.equals(statusModerate)) {
            return AdPageModerationStatus.ACTIVATING;
        } else if (StatusModerateBannerPage.NO.equals(statusModerate)) {
            return AdPageModerationStatus.REJECTED;
        } else { // READY, SENT, MAYBE
            return AdPageModerationStatus.ON_MODERATION;
        }
    }

    enum AdPageModerationStatus {
        ACCEPTED, REJECTED, ACTIVATING, ON_MODERATION
    }
}
