package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntityActiveCounter implements ActiveCounter {
    private final int activeEntities;
    private final int runnableEntities;

    public EntityActiveCounter(int activeEntities, int runnableEntities) {
        this.activeEntities = activeEntities;
        this.runnableEntities = runnableEntities;
    }

    @Override
    public int active() {
        return activeEntities;
    }

    @Override
    public boolean isAllActive() {
        return hasActive() && activeEntities == runnableEntities;
    }

    @Override
    public boolean hasActive() {
        return activeEntities > 0;
    }
}
