package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ShowConditionsActiveCounter implements ActiveCounter {
    private final int activeKeywords;
    private final int activeRetargetings;
    private final int nonSuspendedShowConditions;
    private final int activeInterests;
    private final int internalShowConditions;
    private final int runnableShowConditions;

    public ShowConditionsActiveCounter(int activeKeywords, int activeRetargetings, int nonSuspendedShowConditions,
                                       int activeInterests, int internalShowConditions, int runnableShowConditions) {
        this.activeKeywords = activeKeywords;
        this.activeRetargetings = activeRetargetings;
        this.nonSuspendedShowConditions = nonSuspendedShowConditions;
        this.activeInterests = activeInterests;
        this.internalShowConditions = internalShowConditions;
        this.runnableShowConditions = runnableShowConditions;
    }

    @Override
    public int active() {
        return activeKeywords + activeRetargetings + activeInterests + internalShowConditions
                + nonSuspendedShowConditions;
    }

    @Override
    public boolean isAllActive() {
        return hasActive() && active() == runnableShowConditions;
    }

    @Override
    public boolean hasActive() {
        return active() > 0;
    }
}
