package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Archived.ArchivedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft.DraftCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.DraftOnModeration.DraftOnModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Moderation.ModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.OkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing.ProcessingCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Rejected.RejectedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.RunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended.SuspendedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Warning.WarningCounter;

@ParametersAreNonnullByDefault
public final class AdsCounters {
    public final ArchivedCounter archivedCounter;
    public final ActiveCounter activeCounter;
    public final DraftCounter draftCounter;
    public final ModerationCounter moderationCounter;
    public final OkCounter okCounter;
    public final ProcessingCounter processingCounter;
    public final RejectedCounter rejectedCounter;
    public final RunnableCounter runnableCounter;
    public final SuspendedCounter suspendedCounter;
    public final WarningCounter warningCounter;
    public final DraftOnModerationCounter draftOnModerationCounter;

    public AdsCounters(ArchivedCounter archivedCounter, ActiveCounter activeCounter, DraftCounter draftCounter,
                       ModerationCounter moderationCounter, OkCounter okCounter, ProcessingCounter processingCounter,
                       RejectedCounter rejectedCounter, RunnableCounter runnableCounter,
                       SuspendedCounter suspendedCounter, WarningCounter warningCounter,
                       DraftOnModerationCounter draftOnModerationCounter) {
        this.archivedCounter = archivedCounter;
        this.activeCounter = activeCounter;
        this.draftCounter = draftCounter;
        this.moderationCounter = moderationCounter;
        this.okCounter = okCounter;
        this.rejectedCounter = rejectedCounter;
        this.runnableCounter = runnableCounter;
        this.suspendedCounter = suspendedCounter;
        this.warningCounter = warningCounter;
        this.processingCounter = processingCounter;
        this.draftOnModerationCounter = draftOnModerationCounter;
    }
}
