package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.EntityActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ShowConditionsActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Archived.ArchivedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Archived.EntityArchivedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.BlGenerated.BlGeneratedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.BlGenerated.EntityBlGeneratedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft.DraftCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft.EntityDraftConter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.DraftOnModeration.DraftOnModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.DraftOnModeration.EntityDraftOnModeration;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Moderation.EntityModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Moderation.ModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.EntityOkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.OkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing.EntityProcessingCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing.ProcessingCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Rejected.EntityRejectedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Rejected.RejectedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.AdGroupsRunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.AdsRunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.KeywordsRunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.RetargetingsRunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.RunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.ShowConditionsRunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Stopped.EntityStoppedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Stopped.StoppedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended.EntitySuspendedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended.ShowConditionSuspendedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended.SuspendedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Warning.EntityWarningCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Warning.WarningCounter;
import ru.yandex.direct.core.aggregatedstatuses.repository.ShowConditionsCounter;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.ad.AdStatesEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AdGroupCounters;
import ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AdGroupStatesEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.campaign.CampaignCounters;

import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.ARCHIVED;
import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.DRAFT;
import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.ON_MODERATION;
import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.RUN_WARN;
import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.STOP_CRIT;
import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.STOP_OK;
import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.STOP_PROCESSING;
import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.STOP_WARN;

@ParametersAreNonnullByDefault
public final class AdvancedCounters {
    private final TotalCounter totalCounter;
    private final CampaignCounters campaignCounters;
    private final AdGroupCounters adGroupCounters;
    private final ShowConditionsCounter showConditionsCounter;
    private final int activeInterests;
    private final int internalShowConditions;

    public AdvancedCounters(TotalCounter totalCounter,
                            AdGroupCounters counters,
                            ShowConditionsCounter showConditionsCounter,
                            int activeInterests,
                            int internalShowConditions) {
        this.totalCounter = totalCounter;
        this.adGroupCounters = counters;
        this.showConditionsCounter = showConditionsCounter;
        this.activeInterests = activeInterests;
        this.internalShowConditions = internalShowConditions;

        this.campaignCounters = new CampaignCounters();
    }

    public AdvancedCounters(TotalCounter totalCounter, CampaignCounters campaignCounters) {
        this.totalCounter = totalCounter;
        this.campaignCounters = campaignCounters;
        this.adGroupCounters = new AdGroupCounters();
        this.showConditionsCounter = new ShowConditionsCounter();
        this.activeInterests = 0;
        this.internalShowConditions = 0;
    }

    public KeywordsCounters keywordsCounters() {
        final ArchivedCounter keywordsArchivedCounter = new EntityArchivedCounter(totalCounter.keywords(),
                adGroupCounters.getKeywordStatuses().getOrDefault(ARCHIVED, 0));

        final SuspendedCounter keywordsSuspendedCounter = new EntitySuspendedCounter(
                adGroupCounters.getKeywordStatuses().getOrDefault(STOP_OK, 0),
                keywordsArchivedCounter.nonArchived());

        final DraftCounter keywordsDraftCounter = new EntityDraftConter(
                adGroupCounters.getKeywordStatuses().getOrDefault(DRAFT, 0),
                keywordsArchivedCounter.nonArchived());

        final RunnableCounter keywordsRunnableCounter = new KeywordsRunnableCounter(
                keywordsArchivedCounter.nonArchived(), keywordsSuspendedCounter.suspended(),
                keywordsDraftCounter.draft());

        return new KeywordsCounters(keywordsArchivedCounter, keywordsSuspendedCounter, keywordsDraftCounter,
                keywordsRunnableCounter);
    }

    public RetargetingsCounters retargetingsCounters() {
        final ArchivedCounter retargetingsArchivedCounter = new EntityArchivedCounter(totalCounter.retargetings(),
                adGroupCounters.getRetargetingStatuses().getOrDefault(ARCHIVED, 0));

        final SuspendedCounter retargetingsSuspendedCounter = new EntitySuspendedCounter(
                adGroupCounters.getRetargetingStatuses().getOrDefault(STOP_OK, 0),
                retargetingsArchivedCounter.nonArchived());

        final RunnableCounter retargetingsRunnableCounter = new RetargetingsRunnableCounter(totalCounter.retargetings(),
                retargetingsSuspendedCounter.suspended());

        return new RetargetingsCounters(retargetingsArchivedCounter, retargetingsSuspendedCounter,
                retargetingsRunnableCounter);
    }

    public ShowConditionsCounters showConditionsCounters() {
        final var keywordsCounters = keywordsCounters();
        final var retargetingsCounters = retargetingsCounters();

        final SuspendedCounter showConditionsSuspendedCounter = new ShowConditionSuspendedCounter(
                keywordsCounters.suspendedCounter.suspended(), retargetingsCounters.suspendedCounter.suspended(),
                showConditionsCounter.getSuspended(), keywordsCounters.archivedCounter.nonArchived(),
                retargetingsCounters.archivedCounter.nonArchived(), showConditionsCounter.getNonSuspended());

        final WarningCounter showConditionsWarningCounter = new EntityWarningCounter(
                adGroupCounters.getKeywordStatuses().getOrDefault(RUN_WARN, 0),
                adGroupCounters.getKeywordStatuses().getOrDefault(STOP_WARN, 0));

        final RejectedCounter showConditionsRejectedCounter = new EntityRejectedCounter(
                adGroupCounters.getKeywordStatuses().getOrDefault(STOP_CRIT, 0),
                keywordsCounters.archivedCounter.nonArchived());

        final RunnableCounter showConditionsRunnableCounter = new ShowConditionsRunnableCounter(
                keywordsCounters.runnableCounter.runnable(), retargetingsCounters.runnableCounter.runnable(),
                activeInterests, internalShowConditions, showConditionsCounter.getNonSuspended());

        final ActiveCounter showConditionsActiveCounter = new ShowConditionsActiveCounter(
                new SumStatuses(GdSelfStatusEnum.allRun(), adGroupCounters.getKeywordStatuses()).intValue(),
                new SumStatuses(GdSelfStatusEnum.allRun(), adGroupCounters.getRetargetingStatuses()).intValue(),
                showConditionsCounter.getNonSuspended(), activeInterests, internalShowConditions,
                showConditionsRunnableCounter.runnable());

        return new ShowConditionsCounters(showConditionsSuspendedCounter, showConditionsActiveCounter,
                showConditionsWarningCounter, showConditionsRejectedCounter, showConditionsRunnableCounter);
    }

    public AdsCounters adsCounters() {
        final ArchivedCounter adsArchivedCounter = new EntityArchivedCounter(totalCounter.ads(),
                adGroupCounters.getAdStatuses().getOrDefault(ARCHIVED, 0));

        final DraftCounter adsDraftCounter = new EntityDraftConter(
                adGroupCounters.getAdStatuses().getOrDefault(DRAFT, 0), adsArchivedCounter.nonArchived());

        final SuspendedCounter adsSuspendedCounter = new EntitySuspendedCounter(
                adGroupCounters.getAdStatuses().getOrDefault(STOP_OK, 0), adsArchivedCounter.nonArchived());

        final ModerationCounter adsModerationCounter = new EntityModerationCounter(
                adGroupCounters.getAdStatuses().getOrDefault(ON_MODERATION, 0), adsArchivedCounter.nonArchived());

        final RunnableCounter adsRunnableCounter = new AdsRunnableCounter(adsArchivedCounter.nonArchived(),
                adsSuspendedCounter.suspended(), adsDraftCounter.draft(), adsModerationCounter.onModeration());

        final ActiveCounter adsActiveCounter = new EntityActiveCounter(
                new SumStatuses(GdSelfStatusEnum.allRun(), adGroupCounters.getAdStatuses()).intValue(), adsRunnableCounter.runnable());

        final OkCounter adsOkCounter = new EntityOkCounter(totalCounter.ads(),
                new SumStatuses(GdSelfStatusEnum.allOk(), adGroupCounters.getAdStatuses()).intValue());

        final ProcessingCounter adsProcessingCounter = new EntityProcessingCounter(
                new SumStatuses(GdSelfStatusEnum.allProcessing(), adGroupCounters.getAdStatuses()).intValue(), adsRunnableCounter.runnable());

        final WarningCounter adsWarningCounter = new EntityWarningCounter(
                adGroupCounters.getAdStatuses().getOrDefault(RUN_WARN, 0),
                adGroupCounters.getAdStatuses().getOrDefault(STOP_WARN, 0));

        final RejectedCounter adsRejectedCounter = new EntityRejectedCounter(
                adGroupCounters.getAdStatuses().getOrDefault(STOP_CRIT, 0), adsArchivedCounter.nonArchived());

        final DraftOnModerationCounter adsDraftOnModerationCounter = new EntityDraftOnModeration(
                adGroupCounters.getAdStates().getOrDefault(AdStatesEnum.DRAFT_ON_MODERATION, 0), adsArchivedCounter.nonArchived());

        return new AdsCounters(adsArchivedCounter, adsActiveCounter, adsDraftCounter, adsModerationCounter,
                adsOkCounter, adsProcessingCounter, adsRejectedCounter, adsRunnableCounter, adsSuspendedCounter,
                adsWarningCounter, adsDraftOnModerationCounter);
    }

    public AdGroupsCounters adGroupsCounters() {
        final ArchivedCounter archivedCounter = new EntityArchivedCounter(
                totalCounter.adGroups(), campaignCounters.getStatuses().getOrDefault(ARCHIVED, 0));

        final DraftCounter draftCounter = new EntityDraftConter(
                campaignCounters.getStatuses().getOrDefault(DRAFT, 0), archivedCounter.nonArchived());

        final SuspendedCounter suspendedCounter = new EntitySuspendedCounter(
                campaignCounters.getStatuses().getOrDefault(STOP_OK, 0), archivedCounter.nonArchived());

        final DraftOnModerationCounter draftOnModerationCounter = new EntityDraftOnModeration(
                campaignCounters.getStates().getOrDefault(AdGroupStatesEnum.HAS_DRAFT_ON_MODERATION_ADS, 0), archivedCounter.nonArchived());

        final RunnableCounter runnableCounter = new AdGroupsRunnableCounter(
                archivedCounter.nonArchived(), suspendedCounter.suspended(), draftCounter.draft());

        final ActiveCounter activeCounter = new EntityActiveCounter(
                new SumStatuses(GdSelfStatusEnum.allRun(), campaignCounters.getStatuses()).intValue(),
                runnableCounter.runnable());

        final ModerationCounter moderationCounter = new EntityModerationCounter(
                campaignCounters.getStatuses().getOrDefault(ON_MODERATION, 0), archivedCounter.nonArchived());

        final WarningCounter warningCounter = new EntityWarningCounter(
                campaignCounters.getStatuses().getOrDefault(RUN_WARN, 0),
                campaignCounters.getStatuses().getOrDefault(STOP_WARN, 0));

        final ProcessingCounter processingCounter = new EntityProcessingCounter(
                new SumStatuses(GdSelfStatusEnum.allProcessing(), campaignCounters.getStatuses()).intValue(),
                runnableCounter.runnable());

        final OkCounter okCounter = new EntityOkCounter(
                totalCounter.adGroups(),
                new SumStatuses(GdSelfStatusEnum.allOk(), campaignCounters.getStatuses()).intValue());

        final BlGeneratedCounter blGeneratedCounter = new EntityBlGeneratedCounter(
                campaignCounters.getStates().getOrDefault(AdGroupStatesEnum.STATUS_BL_GENERATED_PROCESSING, 0),
                campaignCounters.getStates().getOrDefault(AdGroupStatesEnum.STATUS_BL_GENERATED_NOTHING_GENERATED, 0),
                archivedCounter.nonArchived());

        final StoppedCounter stoppedCounter = new EntityStoppedCounter(
                campaignCounters.getStatuses().getOrDefault(STOP_CRIT, 0),
                campaignCounters.getStatuses().getOrDefault(STOP_PROCESSING, 0));

        return new AdGroupsCounters(archivedCounter, draftCounter, suspendedCounter, draftOnModerationCounter,
                activeCounter, moderationCounter, warningCounter, processingCounter, okCounter, blGeneratedCounter,
                stoppedCounter);
    }
}
