package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Archived;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntityArchivedCounter implements ArchivedCounter {
    private final int archivedEntities;
    private final int totalEntities;

    public EntityArchivedCounter(int totalEntities, int archivedEntities) {
        this.archivedEntities = archivedEntities;
        this.totalEntities = totalEntities;
    }

    @Override
    public int archived() {
        return archivedEntities;
    }

    @Override
    public int nonArchived() {
        return totalEntities - archivedEntities;
    }

    @Override
    public boolean isAllArchived() {
        return hasArchived() && archived() == totalEntities;
    }

    @Override
    public boolean hasArchived() {
        return archivedEntities > 0;
    }
}
