package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.BlGenerated;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityBlGeneratedCounter implements BlGeneratedCounter {
    private final int blGeneratedProcessing;
    private final int blNothingGenerated;
    private final int nonArchived;

    public EntityBlGeneratedCounter(int blGeneratedProcessing, int blNothingGenerated, int nonArchived) {
        this.blGeneratedProcessing = blGeneratedProcessing;
        this.blNothingGenerated = blNothingGenerated;
        this.nonArchived = nonArchived;
    }

    @Override
    public int blNothingGenerated() {
        return blNothingGenerated;
    }

    @Override
    public int blGeneratedProcessing() {
        return blGeneratedProcessing;
    }

    @Override
    public boolean isAllBlGeneratedProcessing() {
        return hasBlGeneratedProcessing() && blGeneratedProcessing == nonArchived;
    }

    @Override
    public boolean hasBlGeneratedProcessing() {
        return blGeneratedProcessing > 0;
    }

    @Override
    public boolean hasBlNothingGenerated() {
        return blNothingGenerated > 0;
    }
}
