package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntityDraftConter implements DraftCounter {
    private final int draftEntity;
    private final int nonArchivedEntity;

    public EntityDraftConter(int draftEntity, int nonArchivedEntity) {
        this.draftEntity = draftEntity;
        this.nonArchivedEntity = nonArchivedEntity;
    }

    @Override
    public int draft() {
        return draftEntity;
    }

    @Override
    public boolean isAllDraft() {
        return hasDraft() && nonArchivedEntity == draftEntity;
    }

    @Override
    public boolean hasDraft() {
        return draftEntity > 0;
    }
}
