package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.DraftOnModeration;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntityDraftOnModeration implements DraftOnModerationCounter {
    private final int draftOnModeration;
    private final int nonArchived;

    public EntityDraftOnModeration(int draftOnModeration, int nonArchived) {
        this.draftOnModeration = draftOnModeration;
        this.nonArchived = nonArchived;
    }

    @Override
    public int draftsOnModeration() {
        return draftOnModeration;
    }

    @Override
    public boolean hasDraftOnModeration() {
        return draftOnModeration > 0;
    }

    @Override
    public boolean isAllDraftOnModeration() {
        return hasDraftOnModeration() && draftOnModeration == nonArchived;
    }
}
