package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Moderation;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntityModerationCounter implements ModerationCounter {
    private final int onModeration;
    private final int nonArchived;

    public EntityModerationCounter(int onModeration, int nonArchived) {
        this.onModeration = onModeration;
        this.nonArchived = nonArchived;
    }

    @Override
    public int onModeration() {
        return onModeration;
    }

    @Override
    public boolean hasOnModeration() {
        return onModeration > 0;
    }

    @Override
    public boolean isAllOnModeration() {
        return hasOnModeration() && onModeration == nonArchived;
    }
}
