package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntityProcessingCounter implements ProcessingCounter {
    private final int processingEntities;
    private final int runnableEntities;

    public EntityProcessingCounter(int processingEntities, int runnableEntities) {
        this.processingEntities = processingEntities;
        this.runnableEntities = runnableEntities;
    }

    @Override
    public boolean isAllProcessing() {
        return hasProcessing() && runnableEntities == processingEntities;
    }

    @Override
    public boolean hasProcessing() {
        return processingEntities > 0;
    }
}
