package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Rejected;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntityRejectedCounter implements RejectedCounter {
    private final int rejectedEntities;
    private final int nonArchivedEntities;

    public EntityRejectedCounter(int rejectedEntities, int nonArchivedEntities) {
        this.rejectedEntities = rejectedEntities;
        this.nonArchivedEntities = nonArchivedEntities;
    }

    @Override
    public boolean hasRejected() {
        return rejectedEntities > 0;
    }

    @Override
    public boolean isAllRejected() {
        return hasRejected() && rejectedEntities == nonArchivedEntities;
    }
}
