package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AdGroupsRunnableCounter implements RunnableCounter {
    private final int nonArchivedGroups;
    private final int suspendedGroups;
    private final int draftGroups;

    public AdGroupsRunnableCounter(int nonArchivedGroups, int suspendedGroups, int draftGroups) {
        this.nonArchivedGroups = nonArchivedGroups;
        this.suspendedGroups = suspendedGroups;
        this.draftGroups = draftGroups;
    }

    @Override
    public int runnable() {
        return nonArchivedGroups - suspendedGroups - draftGroups;
    }

    @Override
    public boolean hasRunnable() {
        return runnable() > 0;
    }
}
