package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class AdsRunnableCounter implements RunnableCounter {
    private final int nonArchivedAds;
    private final int suspendedAds;
    private final int draftAds;
    private final int onModerationAds;

    public AdsRunnableCounter(int nonArchivedAds, int suspendedAds, int draftAds, int onModerationAds) {
        this.nonArchivedAds = nonArchivedAds;
        this.suspendedAds = suspendedAds;
        this.draftAds = draftAds;
        this.onModerationAds = onModerationAds;
    }

    @Override
    public int runnable() {
        return nonArchivedAds - suspendedAds - draftAds - onModerationAds;
    }

    @Override
    public boolean hasRunnable() {
        return runnable() > 0;
    }
}
