package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class KeywordsRunnableCounter implements RunnableCounter {
    private final int nonArchivedKeywords;
    private final int suspendedKeywords;
    private final int draftKeywords;

    public KeywordsRunnableCounter(int nonArchivedKeywords, int suspendedKeywords, int draftKeywords) {
        this.nonArchivedKeywords = nonArchivedKeywords;
        this.suspendedKeywords = suspendedKeywords;
        this.draftKeywords = draftKeywords;
    }

    @Override
    public int runnable() {
        return nonArchivedKeywords - suspendedKeywords - draftKeywords;
    }

    @Override
    public boolean hasRunnable() {
        return runnable() > 0;
    }
}
