package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class RetargetingsRunnableCounter implements RunnableCounter {
    private final int retargetingsTotal;
    private final int suspendedRetargetings;

    public RetargetingsRunnableCounter(int retargetingsTotal, int suspendedRetargetings) {
        this.retargetingsTotal = retargetingsTotal;
        this.suspendedRetargetings = suspendedRetargetings;
    }
    @Override
    public int runnable() {
        return retargetingsTotal - suspendedRetargetings;
    }

    @Override
    public boolean hasRunnable() {
        return runnable() > 0;
    }
}
