package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ShowConditionsRunnableCounter implements RunnableCounter {
    private final int runnableKeywords;
    private final int runnableRetargetings;
    private final int activeInterests;
    private final int internalShowConditions;
    private final int nonSuspendedShowConditions;

    public ShowConditionsRunnableCounter(int runnableKeywords, int runnableRetargetings, int activeInterests, int internalShowConditions, int nonSuspendedShowConditions) {
        this.runnableKeywords = runnableKeywords;
        this.runnableRetargetings = runnableRetargetings;
        this.activeInterests = activeInterests;
        this.internalShowConditions = internalShowConditions;
        this.nonSuspendedShowConditions = nonSuspendedShowConditions;

    }
    @Override
    public int runnable() {
        return runnableKeywords + runnableRetargetings + activeInterests + internalShowConditions
                + nonSuspendedShowConditions;
    }

    @Override
    public boolean hasRunnable() {
        return runnable() > 0;
    }
}
