package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;

@ParametersAreNonnullByDefault
public final class SumStatuses extends Number {
    private final Collection<GdSelfStatusEnum> statuses;
    private final Map<GdSelfStatusEnum, Integer> counters;

    public SumStatuses(Collection<GdSelfStatusEnum> statuses, Map<GdSelfStatusEnum, Integer> counters) {
        this.statuses = statuses;
        this.counters = counters;
    }

    @Override
    public int intValue() {
        return statuses.stream().map(st -> counters.getOrDefault(st, 0)).reduce(0, Integer::sum);
    }

    @Override
    public long longValue() {
        return intValue();
    }

    @Override
    public float floatValue() {
        return intValue();
    }

    @Override
    public double doubleValue() {
        return intValue();
    }
}
