package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntitySuspendedCounter implements SuspendedCounter {
    private final int suspendedEntities;
    private final int nonArchivedEntities;

    public EntitySuspendedCounter(int suspendedEntities, int nonArchivedEntities) {
        this.suspendedEntities = suspendedEntities;
        this.nonArchivedEntities = nonArchivedEntities;
    }

    @Override
    public int suspended() {
        return suspendedEntities;
    }

    @Override
    public boolean isAllSuspended() {
        return hasSuspended() && suspendedEntities == nonArchivedEntities;
    }

    @Override
    public boolean hasSuspended() {
        return suspendedEntities > 0;
    }
}
