package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ShowConditionSuspendedCounter implements SuspendedCounter {
    private final int suspendedKeywords;
    private final int suspendedRetargetings;
    private final int suspendedShowConditions;
    private final int nonArchivedKeywords;
    private final int nonArchivedRetargetings;
    private final int nonSuspendedShowConditions;

    public ShowConditionSuspendedCounter(int suspendedKeywords, int suspendedRetargetings, int suspendedShowConditions,
                                         int nonArchivedKeywords, int nonArchivedRetargetings,
                                         int nonSuspendedShowConditions) {
        this.suspendedKeywords = suspendedKeywords;
        this.suspendedRetargetings = suspendedRetargetings;
        this.suspendedShowConditions = suspendedShowConditions;
        this.nonArchivedRetargetings = nonArchivedRetargetings;
        this.nonArchivedKeywords = nonArchivedKeywords;
        this.nonSuspendedShowConditions = nonSuspendedShowConditions;
    }

    @Override
    public int suspended() {
        return suspendedKeywords + suspendedRetargetings + suspendedShowConditions;
    }

    @Override
    public boolean isAllSuspended() {
        return hasSuspended()
                && suspended() == nonArchivedKeywords + nonArchivedRetargetings
                && nonSuspendedShowConditions == 0;
    }

    @Override
    public boolean hasSuspended() {
        return suspended() > 0;
    }
}
