package ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class TotalCounter {
    private final int campaignsTotal;
    private final int adsTotal;
    private final int adGroupsTotal;
    private final int keywordsTotal;
    private final int retargetingsTotal;
    private final int activeInterests;
    private final int internalShowConditions;
    private final int showConditionsTotal;

    public TotalCounter(int campaignsTotal, int adsTotal, int adGroupsTotal, int keywordsTotal,
                        int retargetingsTotal, int activeInterests, int internalShowConditions,
                        int showConditionsTotal) {
        this.campaignsTotal = campaignsTotal;
        this.adsTotal = adsTotal;
        this.adGroupsTotal = adGroupsTotal;
        this.keywordsTotal = keywordsTotal;
        this.retargetingsTotal = retargetingsTotal;
        this.activeInterests = activeInterests;
        this.internalShowConditions = internalShowConditions;
        this.showConditionsTotal = showConditionsTotal;
    }

    public int campaigns() {
        return campaignsTotal;
    }

    public int ads() {
        return adsTotal;
    }

    public int adGroups() {
        return adGroupsTotal;
    }

    public int keywords() {
        return keywordsTotal;
    }

    public int retargetings() {
        return retargetingsTotal;
    }

    public int showConditions() {
        return keywordsTotal + retargetingsTotal + activeInterests + internalShowConditions + showConditionsTotal;
    }
}
