package ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Archived;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Archived.ArchivedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;

@ParametersAreNonnullByDefault
public final class CampaignArchivedCondition implements ArchivedCondition {
    private final CampaignStates states;
    private final ArchivedCounter adGroupsArchivedCounter;

    public CampaignArchivedCondition(CampaignStates states, ArchivedCounter adGroupsArchivedCounter) {
        this.states = states;
        this.adGroupsArchivedCounter = adGroupsArchivedCounter;
    }

    @Override
    public boolean isArchived() {
        return states.isArchived() || states.isArchiving() || adGroupsArchivedCounter.isAllArchived();
    }
}
