package ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Draft;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Archived.ArchivedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft.DraftCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.TotalCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;

@ParametersAreNonnullByDefault
public final class AdGroupDraftCondition implements DraftCondition {
    private final AdGroupStates adGroupStates;
    private final TotalCounter totalCounter;
    private final DraftCounter adsDraftCounter;
    private final ArchivedCounter adsArchivedCounter;

    public AdGroupDraftCondition(AdGroupStates adGroupStates,
                                 TotalCounter totalCounter,
                                 DraftCounter adsDraftCounter,
                                 ArchivedCounter adsArchivedCounter) {
        this.adGroupStates = adGroupStates;
        this.totalCounter = totalCounter;
        this.adsDraftCounter = adsDraftCounter;
        this.adsArchivedCounter = adsArchivedCounter;
    }

    @Override
    public boolean isDraft() {
        return (adGroupStates.isDraft() && !adsArchivedCounter.isAllArchived()) // Архивность более сильное свойство
                ||totalCounter.ads() < 1 // Может быть архивным, т.к. нет баннеров
                || (totalCounter.showConditions() < 1 && !adsArchivedCounter.isAllArchived()) // Архивность сильнее, поэтому даже если нет условий нацеливания важнее проверить архивность
                || adsDraftCounter.isAllDraft(); // При наличии объявлений черновиков все не могут быть архивными
    }
}
