package ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.DraftOrSuspended;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntitiesDraftOrSuspendedCondition implements DraftOrSuspendedCondition {
    private final int draftEntity;
    private final int suspendedEntity;
    private final int nonArchivedEntity;

    public EntitiesDraftOrSuspendedCondition(int draftEntity, int suspendedEntity, int nonArchivedEntity) {
        this.draftEntity = draftEntity;
        this.suspendedEntity = suspendedEntity;
        this.nonArchivedEntity = nonArchivedEntity;
    }

    @Override
    public boolean isAllDraftOrSuspended() {
        return (draftEntity > 0 || suspendedEntity > 0) && draftEntity + suspendedEntity == nonArchivedEntity;
    }

    @Override
    public boolean isAllDraft() {
        return draftEntity > 0 && draftEntity == nonArchivedEntity;
    }
}
