package ru.yandex.direct.core.aggregatedstatuses.logic.Conditions;

import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Archived.ArchivedCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.DraftOrSuspended.DraftOrSuspendedCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;

public class EntityConditions implements Conditions {
    private final ModerationCondition moderationCondition;
    private final ArchivedCondition archivedCondition;
    private final DraftOrSuspendedCondition draftOrSuspendedCondition;

    public EntityConditions(ModerationCondition moderationCondition,
                            ArchivedCondition archivedCondition,
                            DraftOrSuspendedCondition draftOrSuspendedCondition) {
        this.moderationCondition = moderationCondition;
        this.archivedCondition = archivedCondition;
        this.draftOrSuspendedCondition = draftOrSuspendedCondition;
    }

    @Override
    public ModerationCondition moderationCondition() {
        return moderationCondition;
    }

    @Override
    public DraftOrSuspendedCondition draftOrSuspendedCondition() {
        return draftOrSuspendedCondition;
    }

    @Override
    public ArchivedCondition archivedCondition() {
        return archivedCondition;
    }
}
