package ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft.DraftCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Rejected.RejectedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.RunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.TotalCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;

@ParametersAreNonnullByDefault
public final class AdGroupShowConditionsModerationCondition implements ModerationCondition {
    private final AdGroupStates states;
    private final TotalCounter totalCounter;
    private final RunnableCounter adsRunnableCounter;
    private final DraftCounter keywordsDraftCounter;
    private final RejectedCounter showConditionsRejectCounter;
    private final ActiveCounter showConditionsActiveCounter;

    public AdGroupShowConditionsModerationCondition(AdGroupStates states,
                                    TotalCounter totalCounter,
                                    RunnableCounter adsRunnableCounter,
                                    DraftCounter keywordsDraftCounter,
                                    RejectedCounter showConditionsRejectCounter,
                                    ActiveCounter showConditionsActiveCounter) {
        this.states = states;
        this.totalCounter = totalCounter;
        this.adsRunnableCounter = adsRunnableCounter;
        this.keywordsDraftCounter = keywordsDraftCounter;
        this.showConditionsRejectCounter = showConditionsRejectCounter;
        this.showConditionsActiveCounter = showConditionsActiveCounter;
    }

    @Override
    public boolean isOnModeration() {
        return adsRunnableCounter.hasRunnable()
                && !states.isRejected()
                && states.onModeration()
                && totalCounter.ads() > 0;
    }

    @Override
    public boolean isPartlyOnModeration() {
        return isOnModeration()
                && keywordsDraftCounter.hasDraft()
                && (showConditionsActiveCounter.hasActive() || showConditionsRejectCounter.hasRejected());
    }

    @Override
    public boolean isFullOnModeration() {
        return isOnModeration() && !isPartlyOnModeration();
    }
}
