package ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.DraftOnModeration.DraftOnModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Moderation.ModerationCounter;

@ParametersAreNonnullByDefault
public final class CampaignModerationCondition implements ModerationCondition {
    private final DraftOnModerationCounter adGroupDraftOnModerationCounter;
    private final ModerationCounter adGroupModerationCounter;
    private final ActiveCounter adGroupActiveCounter;

    public CampaignModerationCondition(DraftOnModerationCounter adGroupDraftOnModerationCounter,
                                       ModerationCounter adGroupModerationCounter,
                                       ActiveCounter adGroupActiveCounter) {
        this.adGroupDraftOnModerationCounter = adGroupDraftOnModerationCounter;
        this.adGroupModerationCounter = adGroupModerationCounter;
        this.adGroupActiveCounter = adGroupActiveCounter;
    }

    @Override
    public boolean isOnModeration() {
        return adGroupDraftOnModerationCounter.hasDraftOnModeration() || adGroupModerationCounter.hasOnModeration();
    }

    @Override
    public boolean isPartlyOnModeration() {
        return isOnModeration() &&  adGroupActiveCounter.hasActive();
    }

    @Override
    public boolean isFullOnModeration() {
        return isOnModeration() && !adGroupActiveCounter.hasActive();
    }
}
