package ru.yandex.direct.core.aggregatedstatuses.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import ru.yandex.direct.core.entity.aggregatedstatuses.keyword.KeywordStatesEnum;
import ru.yandex.direct.core.entity.keyword.aggrstatus.StatusAggregationKeyword;
import ru.yandex.direct.core.entity.keyword.model.StatusModerate;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class KeywordStates implements StatesCalculator<StatusAggregationKeyword, KeywordStatesEnum> {
    @Override
    public Collection<KeywordStatesEnum> calc(StatusAggregationKeyword keyword) {
        List<KeywordStatesEnum> states = new ArrayList<>();
        if (nvl(keyword.getIsSuspended(), false)) {
            states.add(KeywordStatesEnum.SUSPENDED);
        }

        var statusModerate = keyword.getStatusModerate();
        if (StatusModerate.NEW.equals(statusModerate)) {
            states.add(KeywordStatesEnum.DRAFT);
        } else if (StatusModerate.NO.equals(statusModerate)) {
            states.add(KeywordStatesEnum.REJECTED);
        }
        return states;
    }
}
