package ru.yandex.direct.core.aggregatedstatuses.logic;

import java.util.ArrayList;
import java.util.Collection;

import ru.yandex.direct.core.entity.aggregatedstatuses.retargeting.RetargetingStatesEnum;
import ru.yandex.direct.core.entity.retargeting.model.Retargeting;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class RetargetingStates implements StatesCalculator<Retargeting, RetargetingStatesEnum> {
    @Override
    public Collection<RetargetingStatesEnum> calc(Retargeting retargeting) {
        var states = new ArrayList<RetargetingStatesEnum>();
        if (nvl(retargeting.getIsSuspended(), false)) {
            states.add(RetargetingStatesEnum.SUSPENDED);
        }

        return states;
    }
}
