package ru.yandex.direct.core.aggregatedstatuses.logic.States;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AdGroupStatesEnum;

@ParametersAreNonnullByDefault
public final class AdGroupStates {
    private final Collection<AdGroupStatesEnum> states;
    private final boolean hasBannerGeoLegalFlag;

    public AdGroupStates(Collection<AdGroupStatesEnum> states, boolean hasBannerGeoLegalFlag) {
        this.states = states;
        this.hasBannerGeoLegalFlag = hasBannerGeoLegalFlag;
    }

    public boolean isDraft() {
        return states.contains(AdGroupStatesEnum.DRAFT);
    }

    public boolean isRejected() {
        return states.contains(AdGroupStatesEnum.REJECTED);
    }

    public boolean isBlGeneratedProcessing() {
        return states.contains(AdGroupStatesEnum.STATUS_BL_GENERATED_PROCESSING);
    }

    public boolean isBlGeneratedNothingGenerated() {
        return states.contains(AdGroupStatesEnum.STATUS_BL_GENERATED_NOTHING_GENERATED);
    }

    public boolean onModeration() {
        return states.contains(AdGroupStatesEnum.MODERATION);
    }

    public boolean hasNoEffectiveGeo() {
        return states.contains(AdGroupStatesEnum.HAS_NO_EFFECTIVE_GEO);
    }

    public boolean hasBannerGeoLegalFlag() {
        return hasBannerGeoLegalFlag;
    }

    public boolean hasRestrictedGeo() {
        return states.contains(AdGroupStatesEnum.HAS_RESTRICTED_GEO);
    }
}
