package ru.yandex.direct.core.aggregatedstatuses.logic.States;

import java.util.Collection;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.aggregatedstatuses.campaign.CampaignStatesEnum;

@ParametersAreNonnullByDefault
public final class CampaignStates {
    private final Collection<CampaignStatesEnum> states;
    private final Boolean isDraftApproveAllowed;
    private final boolean hasWallet;

    public CampaignStates(Collection<CampaignStatesEnum> states, @Nullable Boolean isDraftApproveAllowed, boolean hasWallet) {
        this.states = states;
        this.isDraftApproveAllowed = isDraftApproveAllowed;
        this.hasWallet = hasWallet;
    }

    public boolean isArchived() {
        return states.contains(CampaignStatesEnum.ARCHIVED);
    }

    public boolean isArchiving() {
        return states.contains(CampaignStatesEnum.ARCHIVING);
    }

    public boolean isUnarchiving() {
        return states.contains(CampaignStatesEnum.UNARCHIVING);
    }

    public boolean isCantBeUnarchived() {
        return states.contains(CampaignStatesEnum.CANT_BE_UNARCHIVED);
    }

    public boolean isDraft() {
        return states.contains(CampaignStatesEnum.DRAFT);
    }

    public boolean isSuspended() {
        return states.contains(CampaignStatesEnum.SUSPENDED);
    }

    public boolean isUnitsExhausted() {
        return states.contains(CampaignStatesEnum.UNITS_EXHAUSTED);
    }

    public boolean isCpmPriceWaitingToApprove() {
        return states.contains(CampaignStatesEnum.CPM_PRICE_WAITING_FOR_APPROVE);
    }

    public boolean isCpmPriceIncorrect() {
        return states.contains(CampaignStatesEnum.CPM_PRICE_INCORRECT);
    }

    public boolean isCpmPriceNotApproved() {
        return states.contains(CampaignStatesEnum.CPM_PRICE_NOT_APPROVED);
    }

    public boolean isDraftApproveAllowed() {
        return isDraftApproveAllowed != null && isDraftApproveAllowed;
    }

    public boolean noMoney() {
        return states.contains(CampaignStatesEnum.NO_MONEY);
    }

    public boolean awaitPayment() {
        return states.contains(CampaignStatesEnum.AWAIT_PAYMENT);
    }

    public boolean hasWallet() {
        return hasWallet;
    }

    public boolean payForConversionCampaignHasLackOfConversion() {
        return states.contains(CampaignStatesEnum.PAY_FOR_CONVERSION_CAMPAIGN_HAS_LACK_OF_CONVERSION);
    }

    public boolean campaignPayed() {
        return states.contains(CampaignStatesEnum.PAYED);
    }

    public boolean hasPromoExtensionRejected() {
        return states.contains(CampaignStatesEnum.PROMO_EXTENSION_REJECTED);
    }
}
