package ru.yandex.direct.core.aggregatedstatuses.logic.Status.AdGroup;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.AdvancedCounters;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.TotalCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Draft.AdGroupDraftCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Draft.DraftCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.AdGroupShowConditionsModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Statuses;

@ParametersAreNonnullByDefault
public final class AdGroupStatuses implements Statuses {
    private final TotalCounter totalCounter;
    private final AdGroupStates adGroupStates;
    private final AdvancedCounters adGroupAdvancedCounters;

    public AdGroupStatuses(AdGroupStates adGroupStates, TotalCounter totalCounter,
                           AdvancedCounters adGroupAdvancedCounters) {
        this.totalCounter = totalCounter;
        this.adGroupStates = adGroupStates;
        this.adGroupAdvancedCounters = adGroupAdvancedCounters;
    }

    @Override
    public Collection<Status> possibleStatuses() {
        final var adsCounters = adGroupAdvancedCounters.adsCounters();
        final var showConditionsCounters = adGroupAdvancedCounters.showConditionsCounters();
        final var keywordsCounters = adGroupAdvancedCounters.keywordsCounters();

        final ModerationCondition showConditionsModerationCondition = new AdGroupShowConditionsModerationCondition(
                adGroupStates,
                totalCounter,
                adsCounters.runnableCounter,
                keywordsCounters.draftCounter,
                showConditionsCounters.rejectedCounter,
                showConditionsCounters.activeCounter);

        final DraftCondition adGroupDraftCondition = new AdGroupDraftCondition(adGroupStates,
                totalCounter,
                adsCounters.draftCounter,
                adsCounters.archivedCounter);

        final Status archived = new Archived(adsCounters.archivedCounter);
        final Status draft = new Draft(showConditionsModerationCondition,
                adGroupDraftCondition,
                totalCounter,
                adGroupStates,
                adsCounters,
                showConditionsCounters);

        final Status onModeration = new OnModeration(showConditionsModerationCondition,
                adGroupStates,
                adsCounters.activeCounter,
                showConditionsCounters.activeCounter,
                adsCounters.draftCounter,
                adsCounters.moderationCounter,
                adsCounters.runnableCounter,
                adsCounters.draftOnModerationCounter);

        final Status runOk = new RunOk(showConditionsModerationCondition,
                adGroupStates,
                adsCounters.activeCounter,
                showConditionsCounters.activeCounter,
                adsCounters.warningCounter,
                showConditionsCounters.warningCounter,
                adsCounters.rejectedCounter,
                showConditionsCounters.rejectedCounter,
                adsCounters.draftOnModerationCounter,
                adsCounters.okCounter);

        final Status runProcessing = new RunProcessing(adGroupStates,
                adsCounters.okCounter,
                adsCounters.processingCounter,
                adsCounters.activeCounter,
                showConditionsCounters.activeCounter);

        final Status runWarn = new RunWarn(adGroupDraftCondition,
                showConditionsModerationCondition,
                adGroupStates,
                adsCounters,
                showConditionsCounters);

        final Status stopCrit = new StopCrit(showConditionsModerationCondition,
                adGroupDraftCondition,
                adGroupStates,
                adsCounters,
                showConditionsCounters);

        final Status stopOk = new StopOk(adGroupDraftCondition,
                adsCounters.suspendedCounter,
                showConditionsCounters.suspendedCounter,
                adsCounters.archivedCounter);

        final Status stopProcessing = new StopProcessing(adGroupStates,
                adGroupDraftCondition,
                adsCounters.activeCounter,
                showConditionsCounters.activeCounter,
                adsCounters.processingCounter,
                adsCounters.okCounter);

        return List.of(archived, draft, onModeration, runOk, runProcessing, runWarn, stopCrit, stopOk, stopProcessing);
    }
}
