package ru.yandex.direct.core.aggregatedstatuses.logic.Status.AdGroup;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.AdsCounters;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.ShowConditionsCounters;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.TotalCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Draft.DraftCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.AdGroup.AdGroupModerationReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.DRAFT;
import static ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus.status;

@ParametersAreNonnullByDefault
public final class Draft implements Status {
    private final ModerationCondition showConditionsModerationCondition;
    private final DraftCondition adGroupDraftCondition;
    private final TotalCounter totalCounter;
    private final AdGroupStates adGroupStates;
    private final AdsCounters adsCounters;
    private final ShowConditionsCounters showConditionsCounters;

    public Draft(ModerationCondition showConditionsModerationCondition,
                 DraftCondition adGroupDraftCondition,
                 TotalCounter totalCounter,
                 AdGroupStates adGroupStates,
                 AdsCounters adsCounters,
                 ShowConditionsCounters showConditionsCounters) {
        this.showConditionsModerationCondition = showConditionsModerationCondition;
        this.adGroupDraftCondition = adGroupDraftCondition;
        this.totalCounter = totalCounter;
        this.adGroupStates = adGroupStates;
        this.adsCounters = adsCounters;
        this.showConditionsCounters = showConditionsCounters;
    }

    @Override
    public boolean isValid() {
        final var condition1 = adGroupDraftCondition.isDraft();
        final var condition2 = !adsCounters.archivedCounter.isAllArchived()
                && (!adsCounters.suspendedCounter.isAllSuspended() && !showConditionsCounters.suspendedCounter.isAllSuspended())
                && !adGroupStates.hasRestrictedGeo()
                && !adGroupStates.hasNoEffectiveGeo()
                && (!adsCounters.activeCounter.hasActive() || !showConditionsCounters.activeCounter.hasActive())
                && ((!adsCounters.activeCounter.hasActive() && !adsCounters.draftCounter.hasDraft()) || !adGroupStates.onModeration())
                && !adsCounters.moderationCounter.hasOnModeration()
                && (!adsCounters.runnableCounter.hasRunnable() || showConditionsCounters.activeCounter.hasActive())
                && adsCounters.draftCounter.hasDraft() && adsCounters.suspendedCounter.hasSuspended();

        return condition1 || condition2;
    }

    @Override
    public SelfStatus selfStatus() {
        final var adGroupModerationReasons = new AdGroupModerationReasons(showConditionsModerationCondition,
                adsCounters.runnableCounter,
                adsCounters.draftOnModerationCounter,
                adsCounters.moderationCounter);

        List<GdSelfStatusReason> allReasons = new ArrayList<>(adGroupModerationReasons.reasons());

        if (adGroupStates.isBlGeneratedProcessing()) {
            allReasons.add(GdSelfStatusReason.ADGROUP_BL_PROCESSING);
        }

        if (totalCounter.showConditions() < 1) {
            allReasons.add(GdSelfStatusReason.ADGROUP_HAS_NO_SHOW_CONDITIONS_ELIGIBLE_FOR_SERVING);
        }

        return !allReasons.isEmpty()
                ? status(DRAFT, allReasons)
                : status(DRAFT);
    }
}
