package ru.yandex.direct.core.aggregatedstatuses.logic.Status.AdGroup;

import java.util.ArrayList;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft.DraftCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.DraftOnModeration.DraftOnModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Moderation.ModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.RunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.AdGroup.AdGroupModerationReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.ON_MODERATION;
import static ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus.status;

@ParametersAreNonnullByDefault
public final class OnModeration implements Status {
    private final ModerationCondition showConditionsModerationCondition;
    private final AdGroupStates adGroupStates;
    private final ActiveCounter adsActiveCounter;
    private final ActiveCounter showConditionsActiveCounter;
    private final DraftCounter adsDraftCounter;
    private final ModerationCounter adsModerationCounter;
    private final RunnableCounter adsRunnableCounter;
    private final DraftOnModerationCounter adsDraftOnModerationCounter;

    public OnModeration(ModerationCondition showConditionsModerationCondition,
                        AdGroupStates adGroupStates,
                        ActiveCounter adsActiveCounter,
                        ActiveCounter showConditionsActiveCounter,
                        DraftCounter adsDraftCounter,
                        ModerationCounter adsModerationCounter,
                        RunnableCounter adsRunnableCounter,
                        DraftOnModerationCounter adsDraftOnModerationCounter) {
        this.showConditionsModerationCondition = showConditionsModerationCondition;
        this.adGroupStates = adGroupStates;
        this.adsActiveCounter = adsActiveCounter;
        this.showConditionsActiveCounter = showConditionsActiveCounter;
        this.adsDraftCounter = adsDraftCounter;
        this.adsModerationCounter = adsModerationCounter;
        this.adsRunnableCounter = adsRunnableCounter;
        this.adsDraftOnModerationCounter = adsDraftOnModerationCounter;
    }

    @Override
    public boolean isValid() {
        final var notValid = adGroupStates.hasRestrictedGeo()
                || adGroupStates.hasNoEffectiveGeo()
                || (adsActiveCounter.hasActive() && showConditionsActiveCounter.hasActive()); // Это RUN_OK или RUN_WARN

        if (notValid) {
            return false;
        }

        // Если все черновики, то это DRAFT
        final var hasDraftButNotAll = adsDraftCounter.hasDraft() && !adsDraftCounter.isAllDraft();
        final var condition1 = (adsActiveCounter.hasActive() || hasDraftButNotAll)
                && adGroupStates.onModeration();

        final var condition2 = adsModerationCounter.hasOnModeration();

        return condition1 || condition2;
    }

    @Override
    public SelfStatus selfStatus() {
        final var reasons = new ArrayList<>(new AdGroupModerationReasons(
                showConditionsModerationCondition,
                adsRunnableCounter,
                adsDraftOnModerationCounter,
                adsModerationCounter).reasons());

        return status(ON_MODERATION, reasons);
    }
}
