package ru.yandex.direct.core.aggregatedstatuses.logic.Status.AdGroup;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.DraftOnModeration.DraftOnModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.OkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Rejected.RejectedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Warning.WarningCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class RunOk implements Status {
    private final ModerationCondition showConditionsModerationCondition;
    private final AdGroupStates adGroupStates;
    private final ActiveCounter adsActiveCounter;
    private final ActiveCounter showConditionsActiveCounter;
    private final WarningCounter adsWarningsCounter;
    private final WarningCounter showConditionsWarningsCounter;
    private final RejectedCounter adsRejectedCounter;
    private final RejectedCounter showConditionsRejectedCounter;
    private final DraftOnModerationCounter adsDraftOnModerationCounter;
    private final OkCounter adsOkCounter;

    public RunOk(ModerationCondition showConditionsModerationCondition,
                 AdGroupStates adGroupStates,
                 ActiveCounter adsActiveCounter,
                 ActiveCounter showConditionsActiveCounter,
                 WarningCounter adsWarningsCounter,
                 WarningCounter showConditionsWarningsCounter,
                 RejectedCounter adsRejectedCounter,
                 RejectedCounter showConditionsRejectedCounter,
                 DraftOnModerationCounter adsDraftOnModerationCounter,
                 OkCounter adsOkCounter) {
        this.showConditionsModerationCondition = showConditionsModerationCondition;
        this.adGroupStates = adGroupStates;
        this.adsActiveCounter = adsActiveCounter;
        this.showConditionsActiveCounter = showConditionsActiveCounter;
        this.adsWarningsCounter = adsWarningsCounter;
        this.showConditionsWarningsCounter = showConditionsWarningsCounter;
        this.adsRejectedCounter = adsRejectedCounter;
        this.showConditionsRejectedCounter = showConditionsRejectedCounter;
        this.adsDraftOnModerationCounter = adsDraftOnModerationCounter;
        this.adsOkCounter = adsOkCounter;
    }

    @Override
    public boolean isValid() {
        // Это точно не RUN_OK
        if (adGroupStates.hasRestrictedGeo() || adGroupStates.hasNoEffectiveGeo()) {
            return false;
        }

        // Это STOP_CRIT
        if (adGroupStates.isBlGeneratedNothingGenerated() && adsActiveCounter.hasActive()) {
            return false;
        }

        // Это RUN_PROCESSING
        if (adGroupStates.isBlGeneratedProcessing() && adsOkCounter.isAllOk()) {
            return false;
        }

        final var condition1 = showConditionsActiveCounter.isAllActive()
                && adsActiveCounter.isAllActive()
                && !adsWarningsCounter.hasWithWarnings()
                && !showConditionsWarningsCounter.hasWithWarnings()
                && !adGroupStates.onModeration();

        final var condition2 = adsActiveCounter.hasActive()
                && showConditionsActiveCounter.hasActive()
                && !adsRejectedCounter.hasRejected()
                && !adsWarningsCounter.hasWithWarnings()
                && !showConditionsRejectedCounter.hasRejected()
                && !showConditionsWarningsCounter.hasWithWarnings()
                && !showConditionsModerationCondition.isOnModeration()
                && !adsDraftOnModerationCounter.hasDraftOnModeration();

        return condition1 || condition2;
    }

    @Override
    public SelfStatus selfStatus() {
        return SelfStatus.status(GdSelfStatusEnum.RUN_OK);
    }
}
