package ru.yandex.direct.core.aggregatedstatuses.logic.Status.AdGroup;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.OkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing.ProcessingCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.RUN_PROCESSING;
import static ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus.status;

@ParametersAreNonnullByDefault
public final class RunProcessing implements Status {
    private final AdGroupStates adGroupStates;
    private final OkCounter adsOkCounter;
    private final ProcessingCounter adsProcessingCounter;
    private final ActiveCounter adsActiveCounter;
    private final ActiveCounter showConditionsActiveCounter;

    public RunProcessing(AdGroupStates adGroupStates, OkCounter adsOkCounter, ProcessingCounter adsProcessingCounter,
                         ActiveCounter adsActiveCounter, ActiveCounter showConditionsActiveCounter) {
        this.adGroupStates = adGroupStates;
        this.adsOkCounter = adsOkCounter;
        this.adsProcessingCounter = adsProcessingCounter;
        this.adsActiveCounter = adsActiveCounter;
        this.showConditionsActiveCounter = showConditionsActiveCounter;
    }

    @Override
    public boolean isValid() {
        return this.adGroupStates.isBlGeneratedProcessing() && adsOkCounter.isAllOk()
                && !adsProcessingCounter.isAllProcessing()
                && adsActiveCounter.hasActive()
                && showConditionsActiveCounter.hasActive();
    }

    @Override
    public SelfStatus selfStatus() {
        if (adsProcessingCounter.hasProcessing()) {
            return status(RUN_PROCESSING, GdSelfStatusReason.ADGROUP_BL_PROCESSING);
        }

        return status(RUN_PROCESSING, GdSelfStatusReason.ADGROUP_BL_PROCESSING_WITH_OLD_VERSION_SHOWN);
    }
}
