package ru.yandex.direct.core.aggregatedstatuses.logic.Status.AdGroup;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.AdsCounters;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.ShowConditionsCounters;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Draft.DraftCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.AdGroup.AdGroupModerationReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.AdGroup.AdGroupRejectedReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.ComposedReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.RUN_WARN;
import static ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus.status;

@ParametersAreNonnullByDefault
public final class RunWarn implements Status {
    private final DraftCondition adGroupDraftCondition;
    private final ModerationCondition showConditionModerationCondition;
    private final AdGroupStates adGroupStates;
    private final AdsCounters adsCounters;
    private final ShowConditionsCounters showConditionsCounters;

    public RunWarn(DraftCondition adGroupDraftCondition,
                   ModerationCondition showConditionModerationCondition,
                   AdGroupStates adGroupStates,
                   AdsCounters adsCounters,
                   ShowConditionsCounters showConditionsCounters) {
        this.adGroupDraftCondition = adGroupDraftCondition;
        this.showConditionModerationCondition = showConditionModerationCondition;
        this.adGroupStates = adGroupStates;
        this.adsCounters = adsCounters;
        this.showConditionsCounters = showConditionsCounters;
    }

    @Override
    public boolean isValid() {
        final var notValid = adsCounters.archivedCounter.isAllArchived()
                || adGroupDraftCondition.isDraft()
                || (adGroupStates.isBlGeneratedProcessing() && adsCounters.okCounter.isAllOk())
                || (adGroupStates.isBlGeneratedNothingGenerated() && adsCounters.activeCounter.hasActive());

        if (notValid) {
            return false;
        }

        final var allRunOk = showConditionsCounters.activeCounter.isAllActive()
                && adsCounters.activeCounter.isAllActive()
                && !adsCounters.warningCounter.hasWithWarnings()
                && !showConditionsCounters.warningCounter.hasWithWarnings()
                && !adGroupStates.onModeration();

        final var condition1 = adGroupStates.hasRestrictedGeo();
        final var condition2 = !allRunOk && !adGroupStates.hasNoEffectiveGeo() && adsCounters.activeCounter.hasActive() && showConditionsCounters.activeCounter.hasActive()
                && (adsCounters.rejectedCounter.hasRejected()
                    || adsCounters.warningCounter.hasWithWarnings()
                    || showConditionsCounters.rejectedCounter.hasRejected()
                    || showConditionsCounters.warningCounter.hasWithWarnings()
                    || (adGroupStates.isRejected() || adsCounters.draftOnModerationCounter.hasDraftOnModeration() || showConditionModerationCondition.isOnModeration()));

        return condition1 || condition2;
    }

    @Override
    public SelfStatus selfStatus() {
        List<GdSelfStatusReason> reasons = new ArrayList<>();
        final var isolatedReasons = new ComposedReasons(List.of(
                new AdGroupModerationReasons(showConditionModerationCondition, adsCounters.runnableCounter, adsCounters.draftOnModerationCounter, adsCounters.moderationCounter),
                new AdGroupRejectedReasons(adGroupStates, adsCounters.runnableCounter, adsCounters.rejectedCounter))
        ).reasons();

        if (adGroupStates.hasRestrictedGeo()) {
            return status(RUN_WARN, GdSelfStatusReason.ADGROUP_HAS_RESTRICTED_GEO);
        }

        if (adsCounters.rejectedCounter.hasRejected()) {
            reasons.add(GdSelfStatusReason.ADGROUP_HAS_ADS_REJECTED_ON_MODERATION);
        } else if (adsCounters.warningCounter.hasWithWarnings()) {
            reasons.add(GdSelfStatusReason.ADGROUP_HAS_ADS_WITH_WARNINGS);
        }

        if (showConditionsCounters.rejectedCounter.hasRejected()) {
            reasons.add(GdSelfStatusReason.ADGROUP_HAS_SHOW_CONDITIONS_REJECTED_ON_MODERATION);
        } else if (showConditionsCounters.warningCounter.hasWithWarnings()) {
            reasons.add(GdSelfStatusReason.ADGROUP_HAS_SHOW_CONDITIONS_WITH_WARNINGS);
        } else if (!isolatedReasons.isEmpty()) {
            reasons.addAll(isolatedReasons);
        }

        return SelfStatus.status(GdSelfStatusEnum.RUN_WARN, reasons);
    }
}
