package ru.yandex.direct.core.aggregatedstatuses.logic.Status.AdGroup;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.AdsCounters;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.ShowConditionsCounters;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Draft.DraftCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.AdGroup.AdGroupModerationReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.AdGroup.AdGroupRejectedReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.ComposedReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.STOP_CRIT;
import static ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus.status;

@ParametersAreNonnullByDefault
public final class StopCrit implements Status {
    private final ModerationCondition showConditionsModerationCondition;
    private final DraftCondition adGroupDraftCondition;
    private final AdGroupStates adGroupStates;
    private final AdsCounters adsCounters;
    private final ShowConditionsCounters showConditionsCounters;

    public StopCrit(ModerationCondition showConditionsModerationCondition,
                    DraftCondition adGroupDraftCondition,
                    AdGroupStates adGroupStates,
                    AdsCounters adsCounters,
                    ShowConditionsCounters showConditionsCounters) {
        this.showConditionsModerationCondition = showConditionsModerationCondition;
        this.adGroupDraftCondition = adGroupDraftCondition;
        this.adGroupStates = adGroupStates;
        this.adsCounters = adsCounters;
        this.showConditionsCounters = showConditionsCounters;
    }

    @Override
    public boolean isValid() {
        final var notValid = adsCounters.archivedCounter.isAllArchived()
                || adGroupDraftCondition.isDraft()
                || (adGroupStates.isBlGeneratedProcessing() && adsCounters.okCounter.isAllOk())
                || adGroupStates.hasRestrictedGeo();

        if (notValid) {
            return false;
        }

        final var condition1 = adGroupStates.isBlGeneratedNothingGenerated() && adsCounters.activeCounter.hasActive();
        final var condition2 = adGroupStates.hasNoEffectiveGeo();
        final var condition3 = adsCounters.runnableCounter.hasRunnable()
                && !adsCounters.activeCounter.hasActive()
                && !adsCounters.moderationCounter.hasOnModeration(); // Иначе это ON_MODERATION

        final var condition4 = !adGroupStates.onModeration()
                && !adsCounters.moderationCounter.hasOnModeration() // Иначе это статус ON_MODERATION
                && showConditionsCounters.runnableCounter.hasRunnable()
                && !showConditionsCounters.activeCounter.hasActive();

        return condition1 || condition2 || condition3 || condition4;
    }

    @Override
    public SelfStatus selfStatus() {
        if (adGroupStates.isBlGeneratedNothingGenerated() && adsCounters.activeCounter.hasActive()) {
            return status(STOP_CRIT, GdSelfStatusReason.ADGROUP_BL_NOTHING_GENERATED);
        }

        if (adGroupStates.hasNoEffectiveGeo()) {
            return status(STOP_CRIT,
                    adGroupStates.hasBannerGeoLegalFlag()
                            ? GdSelfStatusReason.ADGROUP_NEED_DOCUMENTS_FOR_MODERATION
                            : GdSelfStatusReason.ADGROUP_HAS_NO_EFFECTIVE_GEO);
        }

        final var isolatedReasons = new ComposedReasons(List.of(
                new AdGroupModerationReasons(showConditionsModerationCondition,
                    adsCounters.runnableCounter,
                    adsCounters.draftOnModerationCounter,
                    adsCounters.moderationCounter),
                new AdGroupRejectedReasons(adGroupStates, adsCounters.runnableCounter, adsCounters.rejectedCounter))).reasons();

        if (adsCounters.runnableCounter.hasRunnable() && !adsCounters.activeCounter.hasActive()) {
            final var reasons = new LinkedList<>(isolatedReasons);
            reasons.addFirst(GdSelfStatusReason.ADGROUP_HAS_NO_ADS_ELIGIBLE_FOR_SERVING);

            return status(STOP_CRIT, reasons);
        }

        return status(STOP_CRIT, !isolatedReasons.isEmpty()
                ? new ArrayList<>(isolatedReasons)
                : List.of(GdSelfStatusReason.ADGROUP_HAS_NO_SHOW_CONDITIONS_ELIGIBLE_FOR_SERVING));
    }
}
