package ru.yandex.direct.core.aggregatedstatuses.logic.Status.AdGroup;

import java.util.ArrayList;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Archived.ArchivedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended.SuspendedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Draft.DraftCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.STOP_OK;

@ParametersAreNonnullByDefault
public final class StopOk implements Status {
    private final DraftCondition adGroupDraftCondition;
    private final SuspendedCounter adsSuspendedCounter;
    private final SuspendedCounter showConditionsSuspendedCounter;
    private final ArchivedCounter adsArchivedCounter;

    public StopOk(DraftCondition adGroupDraftCondition,
                  SuspendedCounter adsSuspendedCounter,
                  SuspendedCounter showConditionsSuspendedCounter,
                  ArchivedCounter adsArchivedCounter) {
        this.adGroupDraftCondition = adGroupDraftCondition;
        this.adsSuspendedCounter = adsSuspendedCounter;
        this.showConditionsSuspendedCounter = showConditionsSuspendedCounter;
        this.adsArchivedCounter = adsArchivedCounter;
    }

    @Override
    public boolean isValid() {
        // Не пересекается с архивность, но пересекается с черновиком, когда остановлены все объявления и нет фраз
        final var condition1 = adsSuspendedCounter.isAllSuspended() && !adGroupDraftCondition.isDraft();
        // Пересекается с архивным, когда все объявления архивные, а все условия нацеливания остановлены
        // Пересекается с черновиком, когда все условия нацеливания остановлены, а все объявления черновики
        final var condition2 = showConditionsSuspendedCounter.isAllSuspended()
                && !adGroupDraftCondition.isDraft()
                && !adsArchivedCounter.isAllArchived();

        return condition1 || condition2;
    }

    @Override
    public SelfStatus selfStatus() {
        final var reasons = new ArrayList<GdSelfStatusReason>();

        if (adsSuspendedCounter.isAllSuspended()) {
            reasons.add(GdSelfStatusReason.ADGROUP_ADS_SUSPENDED_BY_USER);
        }

        if (showConditionsSuspendedCounter.isAllSuspended()) {
            reasons.add(GdSelfStatusReason.ADGROUP_SHOW_CONDITIONS_SUSPENDED_BY_USER);
        }

        return SelfStatus.status(STOP_OK, reasons);
    }
}
