package ru.yandex.direct.core.aggregatedstatuses.logic.Status.AdGroup;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.OkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing.ProcessingCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Draft.DraftCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.STOP_PROCESSING;
import static ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus.status;

@ParametersAreNonnullByDefault
public final class StopProcessing implements Status {
    private final AdGroupStates adGroupStates;
    private final DraftCondition adGroupDraftCondition;
    private final ActiveCounter adsActiveCounter;
    private final ActiveCounter showConditionsActiveCounter;
    private final ProcessingCounter adsProcessingCounter;
    private final OkCounter adsOkCounter;

    public StopProcessing(AdGroupStates adGroupStates,
                          DraftCondition adGroupDraftCondition,
                          ActiveCounter adsActiveCounter,
                          ActiveCounter showConditionsActiveCounter,
                          ProcessingCounter adsProcessingCounter,
                          OkCounter adsOkCounter) {
        this.adGroupStates = adGroupStates;
        this.adGroupDraftCondition = adGroupDraftCondition;
        this.adsActiveCounter = adsActiveCounter;
        this.showConditionsActiveCounter = showConditionsActiveCounter;
        this.adsProcessingCounter = adsProcessingCounter;
        this.adsOkCounter = adsOkCounter;
    }

    @Override
    public boolean isValid() {
        return !adGroupDraftCondition.isDraft() && adGroupStates.isBlGeneratedProcessing() && adsOkCounter.isAllOk()
                && (adsProcessingCounter.isAllProcessing() || !adsActiveCounter.hasActive()
                || !showConditionsActiveCounter.hasActive());
    }

    @Override
    public SelfStatus selfStatus() {
        return status(STOP_PROCESSING, GdSelfStatusReason.ADGROUP_BL_PROCESSING);
    }
}
