package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Archived.ArchivedCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

import static ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum.ARCHIVED;
import static ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus.status;

@ParametersAreNonnullByDefault
public final class Archived implements Status {
    private final CampaignStates states;
    private final ArchivedCondition archivedCondition;

    public Archived(CampaignStates states, ArchivedCondition archivedCondition) {
        this.states = states;
        this.archivedCondition = archivedCondition;
    }

    @Override
    public boolean isValid() {
        return archivedCondition.isArchived();
    }

    @Override
    public SelfStatus selfStatus() {
        return states.isCantBeUnarchived()
                ? status(ARCHIVED, GdSelfStatusReason.CAMPAIGN_IS_NOT_RECOVERABLE)
                : status(ARCHIVED);
    }
}
