package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.AdvancedCounters;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.TotalCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Archived.ArchivedCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Archived.CampaignArchivedCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Conditions;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.DraftOrSuspended.DraftOrSuspendedCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.DraftOrSuspended.EntitiesDraftOrSuspendedCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.EntityConditions;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.CampaignModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Statuses;

@ParametersAreNonnullByDefault
public final class CampaignStatuses implements Statuses {
    private final CampaignStates campaignStates;
    private final TotalCounter totalCounter;
    private final AdvancedCounters campaignAdvancedCounters;

    public CampaignStatuses(CampaignStates campaignStates, TotalCounter totalCounter,
                            AdvancedCounters campaignAdvancedCounters) {
        this.campaignStates = campaignStates;
        this.totalCounter = totalCounter;
        this.campaignAdvancedCounters = campaignAdvancedCounters;
    }

    @Override
    public Collection<Status> possibleStatuses() {
        final var adGroupsCounters = campaignAdvancedCounters.adGroupsCounters();
        final DraftOrSuspendedCondition draftOrSuspendedCondition = new EntitiesDraftOrSuspendedCondition(
                adGroupsCounters.draftCounter.draft(),
                adGroupsCounters.suspendedCounter.suspended(),
                adGroupsCounters.archivedCounter.nonArchived());

        final ModerationCondition moderationCondition = new CampaignModerationCondition(
                adGroupsCounters.draftOnModerationCounter,
                adGroupsCounters.moderationCounter,
                adGroupsCounters.activeCounter);

        final ArchivedCondition archivedCondition = new CampaignArchivedCondition(
                campaignStates,
                adGroupsCounters.archivedCounter
        );

        final Conditions conditions = new EntityConditions(moderationCondition, archivedCondition,
                draftOrSuspendedCondition);

        final var archived = new Archived(campaignStates, archivedCondition);
        final var draft = new Draft(campaignStates, conditions, totalCounter, adGroupsCounters.draftCounter);
        final var onModeration = new OnModeration(campaignStates,
                adGroupsCounters.draftCounter,
                adGroupsCounters.activeCounter,
                adGroupsCounters.moderationCounter,
                moderationCondition,
                draftOrSuspendedCondition);

        final var runOk = new RunOk(campaignStates,
                conditions,
                adGroupsCounters.activeCounter,
                adGroupsCounters.warningCounter,
                adGroupsCounters.processingCounter,
                adGroupsCounters.okCounter,
                adGroupsCounters.suspendedCounter);

        final var runProcessing = new RunProcessing(campaignStates,
                adGroupsCounters);

        final var runWarn = new RunWarn(campaignStates,
                adGroupsCounters.activeCounter,
                adGroupsCounters.warningCounter,
                adGroupsCounters.okCounter);

        final var stopCrit = new StopCrit(campaignStates,
                conditions,
                totalCounter,
                adGroupsCounters.draftCounter,
                adGroupsCounters.activeCounter,
                adGroupsCounters.okCounter,
                adGroupsCounters.processingCounter,
                adGroupsCounters.blGeneratedCounter,
                adGroupsCounters.stoppedCounter);

        final var stopOk = new StopOk(campaignStates, adGroupsCounters.suspendedCounter);
        final var stopProcessing = new StopProcessing(campaignStates,
                conditions,
                totalCounter,
                adGroupsCounters.activeCounter,
                adGroupsCounters.okCounter,
                adGroupsCounters.processingCounter,
                adGroupsCounters.blGeneratedCounter,
                adGroupsCounters.stoppedCounter,
                adGroupsCounters.suspendedCounter);

        final var stopWarn = new StopWarn(campaignStates);

        return List.of(archived,
                draft,
                onModeration,
                runOk,
                runProcessing,
                runWarn,
                stopCrit,
                stopOk,
                stopProcessing,
                stopWarn);
    }
}
