package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft.DraftCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.TotalCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Conditions;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign.CampaignCpmReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign.CampaignModerationReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.ComposedReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class Draft implements Status {
    private final CampaignStates campaignStates;
    private final Conditions campaignConditions;
    private final TotalCounter totalCounter;
    private final DraftCounter adGroupsDraftCounter;

    public Draft(CampaignStates campaignsStates,
                 Conditions campaignConditions,
                 TotalCounter totalCounter,
                 DraftCounter adGroupsDraftCounter) {
        this.campaignStates = campaignsStates;
        this.campaignConditions = campaignConditions;
        this.totalCounter = totalCounter;
        this.adGroupsDraftCounter = adGroupsDraftCounter;
    }

    @Override
    public boolean isValid() {
        if (campaignConditions.archivedCondition().isArchived()) {
            return false;
        }

        final var condition1 = campaignStates.isDraft()
                && !campaignConditions.moderationCondition().isFullOnModeration();

        final var condition2 = totalCounter.adGroups() < 1;
        final var condition3 = adGroupsDraftCounter.isAllDraft()
                && !campaignConditions.moderationCondition().isFullOnModeration();

        final var condition4 = !campaignStates.isSuspended() // Если остановлена, то это STOP_OK или STOP_WARN
                && adGroupsDraftCounter.hasDraft() // Если черновиков нет, но все являются черновиками или остановленными, то это статус STOP_OK
                && campaignConditions.draftOrSuspendedCondition().isAllDraftOrSuspended()
                && !campaignConditions.moderationCondition().isFullOnModeration();

        return condition1 || condition2 || condition3 || condition4;
    }

    @Override
    public SelfStatus selfStatus() {
        if (!campaignStates.isDraft() && totalCounter.adGroups() < 1) {
            return SelfStatus.status(GdSelfStatusEnum.DRAFT);
        }

        final var reasons = new ComposedReasons(List.of(
                new CampaignModerationReasons(campaignConditions.moderationCondition()),
                new CampaignCpmReasons(campaignConditions.moderationCondition(), campaignStates)
        )).reasons();

        if (reasons.isEmpty()) {
            return SelfStatus.status(GdSelfStatusEnum.DRAFT);
        }

        return SelfStatus.status(GdSelfStatusEnum.DRAFT, new ArrayList<>(reasons));
    }
}
