package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft.DraftCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Moderation.ModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.DraftOrSuspended.DraftOrSuspendedCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign.CampaignCpmReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign.CampaignModerationReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.ComposedReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class OnModeration implements Status {
    private final CampaignStates campaignStates;
    private final DraftCounter adGroupsDraftCounter;
    private final ActiveCounter adGroupsActiveCounter;
    private final ModerationCounter adGroupsModerationCounter;
    private final ModerationCondition campaignModerationCondition;
    private final DraftOrSuspendedCondition adGroupDraftOrSuspendedCondition;

    public OnModeration(CampaignStates campaignsStates, DraftCounter adGroupsDraftCounter,
                        ActiveCounter adGroupsActiveCounter, ModerationCounter adGroupsModerationCounter,
                        ModerationCondition campaignModerationCondition,
                        DraftOrSuspendedCondition adGroupDraftOrSuspendedCondition) {
        this.campaignStates = campaignsStates;
        this.adGroupsDraftCounter = adGroupsDraftCounter;
        this.adGroupsActiveCounter = adGroupsActiveCounter;
        this.adGroupsModerationCounter = adGroupsModerationCounter;
        this.campaignModerationCondition = campaignModerationCondition;
        this.adGroupDraftOrSuspendedCondition = adGroupDraftOrSuspendedCondition;
    }

    @Override
    public boolean isValid() {
        // Это STOP_OK
        if (campaignStates.isSuspended()) {
            return false;
        }

        final var condition1 = campaignStates.isDraft()
                && campaignModerationCondition.isFullOnModeration()
                && !campaignStates.isCpmPriceNotApproved();

        final var condition2 = adGroupsDraftCounter.isAllDraft()
                && campaignModerationCondition.isFullOnModeration()
                && !campaignStates.isCpmPriceNotApproved();

        final var condition3 = adGroupsDraftCounter.hasDraft() // Если черновиков нет, но все являются черновиками или остановленными, то это статус SUSPENDED
                && adGroupDraftOrSuspendedCondition.isAllDraftOrSuspended()
                && campaignModerationCondition.isFullOnModeration()
                && !campaignStates.isCpmPriceNotApproved();

        final var condition4 = !adGroupDraftOrSuspendedCondition.isAllDraftOrSuspended()
                && !adGroupsActiveCounter.hasActive()
                && adGroupsModerationCounter.hasOnModeration()
                && !campaignStates.isCpmPriceNotApproved();

        return condition1 || condition2 || condition3 || condition4;
    }

    @Override
    public SelfStatus selfStatus() {
        final var reasons = new ComposedReasons(List.of(
                new CampaignModerationReasons(campaignModerationCondition),
                new CampaignCpmReasons(campaignModerationCondition, campaignStates)
        )).reasons();

        return SelfStatus.status(GdSelfStatusEnum.ON_MODERATION, new ArrayList<>(reasons));
    }
}
