package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.OkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing.ProcessingCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended.SuspendedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Warning.WarningCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Conditions;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class RunOk implements Status {
    private final CampaignStates campaignStates;
    private final Conditions campaignConditions;
    private final ActiveCounter adGroupsActiveCounter;
    private final WarningCounter adGroupsWarningCounter;
    private final ProcessingCounter adGroupsProcessingCounter;
    private final OkCounter adGroupsOkCounter;
    private final SuspendedCounter adGroupsSuspendedCounter;

    public RunOk(CampaignStates campaignStates,
                 Conditions campaignConditions,
                 ActiveCounter adGroupsActiveCounter,
                 WarningCounter adGroupsWarningCounter,
                 ProcessingCounter adGroupsProcessingCounter,
                 OkCounter adGroupsOkCounter,
                 SuspendedCounter adGroupsSuspendedCounter) {
        this.campaignStates = campaignStates;
        this.campaignConditions = campaignConditions;
        this.adGroupsActiveCounter = adGroupsActiveCounter;
        this.adGroupsWarningCounter = adGroupsWarningCounter;
        this.adGroupsProcessingCounter = adGroupsProcessingCounter;
        this.adGroupsOkCounter = adGroupsOkCounter;
        this.adGroupsSuspendedCounter = adGroupsSuspendedCounter;
    }

    @Override
    public boolean isValid() {
        if (campaignConditions.archivedCondition().isArchived() || campaignConditions.moderationCondition().isFullOnModeration()) {
            return false;
        }

        if (campaignStates.hasPromoExtensionRejected()) {
            return false;
        }

        final var condition1 = !adGroupsSuspendedCounter.isAllSuspended() // Если остановлена, то это точно не RUN_OK
                && adGroupsActiveCounter.isAllActive()
                && campaignStates.campaignPayed()
                && !adGroupsWarningCounter.hasWithWarnings()
                && !adGroupsProcessingCounter.hasProcessing();

        final var condition2 = !adGroupsSuspendedCounter.isAllSuspended() // Если остановлена, то это точно не RUN_OK
                && adGroupsOkCounter.isAllOk()
                && campaignStates.campaignPayed()
                && !adGroupsProcessingCounter.hasProcessing();

        return condition1 || condition2;
    }

    @Override
    public SelfStatus selfStatus() {
        return SelfStatus.status(GdSelfStatusEnum.RUN_OK);
    }
}
