package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.AdGroupsCounters;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class RunProcessing implements Status {
    private final CampaignStates campaignStates;
    private final AdGroupsCounters adGroupsCounters;

    public RunProcessing(CampaignStates campaignStates,
                         AdGroupsCounters adGroupsCounters) {
        this.campaignStates = campaignStates;
        this.adGroupsCounters = adGroupsCounters;
    }

    @Override
    public boolean isValid() {
        final var condition1 = adGroupsCounters.activeCounter.isAllActive()
                && campaignStates.campaignPayed()
                && !adGroupsCounters.warningCounter.hasWithWarnings()
                && adGroupsCounters.processingCounter.hasProcessing();

        final var condition2 = adGroupsCounters.okCounter.isAllOk()
                && campaignStates.campaignPayed()
                && adGroupsCounters.processingCounter.hasProcessing();

        return condition1 || condition2;
    }

    @Override
    public SelfStatus selfStatus() {
        final var reason = adGroupsCounters.blGeneratedCounter.isAllBlGeneratedProcessing()
                ? GdSelfStatusReason.CAMPAIGN_ADGROUPS_PROCESSING
                : GdSelfStatusReason.CAMPAIGN_HAS_PROCESSING_ADGROUPS;

        return SelfStatus.status(GdSelfStatusEnum.RUN_PROCESSING, reason);
    }
}
