package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.OkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Warning.WarningCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class RunWarn implements Status {
    private final CampaignStates campaignStates;
    private final ActiveCounter adGroupsActiveCounter;
    private final WarningCounter adGroupsWarningCounter;
    private final OkCounter adGroupsOkCounter;

    public RunWarn(CampaignStates campaignStates,
                   ActiveCounter adGroupsActiveCounter,
                   WarningCounter adGroupsWarningCounter,
                   OkCounter adGroupsOkCounter) {
        this.campaignStates = campaignStates;
        this.adGroupsActiveCounter = adGroupsActiveCounter;
        this.adGroupsWarningCounter = adGroupsWarningCounter;
        this.adGroupsOkCounter = adGroupsOkCounter;
    }

    @Override
    public boolean isValid() {
        // Если нет активных или с ворнингом, то это точно не RUN_WARN
        if (!adGroupsActiveCounter.hasActive() && !adGroupsWarningCounter.hasWithWarnings()) {
            return false;
        }

        final var condition1 = campaignStates.payForConversionCampaignHasLackOfConversion();

        final var condition2 = adGroupsActiveCounter.isAllActive()
                && adGroupsWarningCounter.hasWithWarnings()
                && campaignStates.campaignPayed();

        final var condition3 = !adGroupsActiveCounter.isAllActive()
                && !adGroupsOkCounter.isAllOk()
                && campaignStates.campaignPayed();

        final var condition4 = campaignStates.hasPromoExtensionRejected();

        return condition1 || condition2 || condition3 || condition4;
    }

    @Override
    public SelfStatus selfStatus() {
        if (campaignStates.payForConversionCampaignHasLackOfConversion()) {
            return SelfStatus.status(GdSelfStatusEnum.RUN_WARN, GdSelfStatusReason.PAY_FOR_CONVERSION_CAMPAIGN_HAS_LACK_OF_CONVERSION);
        }

        List<GdSelfStatusReason> reasons = new ArrayList<>();

        if (!adGroupsActiveCounter.isAllActive()) {
            reasons.add(GdSelfStatusReason.CAMPAIGN_HAS_INACTIVE_BANNERS);
        }

        if (adGroupsWarningCounter.hasWithWarnings()) {
            reasons.add(GdSelfStatusReason.CAMPAIGN_HAS_ADGROUPS_WITH_WARNINGS);
        }

        if (campaignStates.hasPromoExtensionRejected()) {
            reasons.add(GdSelfStatusReason.PROMO_EXTENSION_REJECTED);
        }

        return SelfStatus.status(GdSelfStatusEnum.RUN_WARN, reasons);
    }
}
