package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.BlGenerated.BlGeneratedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Draft.DraftCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.OkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing.ProcessingCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Stopped.StoppedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.TotalCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Conditions;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign.CampaignCpmReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign.CampaignModerationReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign.CampaignMoneyReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign.CampaignProcessingReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.ComposedReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.CpmReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class StopCrit implements Status {
    private final CampaignStates campaignStates;
    private final Conditions campaignConditions;
    private final TotalCounter totalCounter;
    private final DraftCounter adGroupsDraftCounter;
    private final ActiveCounter adGroupsActiveCounter;
    private final OkCounter adGroupOkCounter;
    private final ProcessingCounter adGroupsProcessingCounter;
    private final BlGeneratedCounter adGroupsBlGeneratedCounter;
    private final StoppedCounter adGroupsStoppedCounter;

    public StopCrit(CampaignStates campaignsStates,
                    Conditions campaignConditions,
                    TotalCounter totalCounter,
                    DraftCounter adGroupsDraftCounter,
                    ActiveCounter adGroupsActiveCounter,
                    OkCounter adGroupOkCounter,
                    ProcessingCounter adGroupsProcessingCounter,
                    BlGeneratedCounter adGroupsBlGeneratedCounter,
                    StoppedCounter adGroupsStoppedCounter) {
        this.campaignStates = campaignsStates;
        this.campaignConditions = campaignConditions;
        this.totalCounter = totalCounter;
        this.adGroupsDraftCounter = adGroupsDraftCounter;
        this.adGroupsActiveCounter = adGroupsActiveCounter;
        this.adGroupOkCounter = adGroupOkCounter;
        this.adGroupsProcessingCounter = adGroupsProcessingCounter;
        this.adGroupsBlGeneratedCounter = adGroupsBlGeneratedCounter;
        this.adGroupsStoppedCounter = adGroupsStoppedCounter;
    }

    @Override
    public boolean isValid() {
        // Если нет групп, то это DRAFT
        if (totalCounter.adGroups() < 1) {
            return false;
        }

        final var condition1 = campaignStates.isDraft()
                && campaignConditions.moderationCondition().isFullOnModeration()
                && campaignStates.isCpmPriceNotApproved();

        final var condition2 = adGroupsDraftCounter.isAllDraft()
                && campaignConditions.moderationCondition().isFullOnModeration()
                && campaignStates.isCpmPriceNotApproved();

        final var condition3 = adGroupsDraftCounter.hasDraft() // Если черновиков нет, но все являются черновиками или остановленными, то это статус STOP_OK
                && campaignConditions.draftOrSuspendedCondition().isAllDraftOrSuspended()
                && campaignConditions.moderationCondition().isFullOnModeration()
                && campaignStates.isCpmPriceNotApproved();

        final var condition4 = !campaignConditions.draftOrSuspendedCondition().isAllDraftOrSuspended() // Если все черновики либо остановленные это STOP_OK или DRAFT
                && !adGroupsActiveCounter.hasActive()
                && campaignConditions.moderationCondition().isFullOnModeration()
                && campaignStates.isCpmPriceNotApproved();

        final var condition5 = !adGroupsActiveCounter.hasActive()
                && !campaignConditions.moderationCondition().isFullOnModeration()
                && !adGroupOkCounter.isAllOk();

        final var condition6 = new CpmReason(campaignStates).reason().isPresent()
                && adGroupsActiveCounter.hasActive();

        final var condition7 = adGroupsActiveCounter.hasActive() && campaignStates.noMoney();

        return condition1 || condition2 || condition3 || condition4 || condition5 || condition6 || condition7;
    }

    @Override
    public SelfStatus selfStatus() {
        final var cpmReason = new CpmReason(campaignStates).reason();
        final var reasons = new ComposedReasons(List.of(
                new CampaignModerationReasons(campaignConditions.moderationCondition()),
                new CampaignCpmReasons(campaignConditions.moderationCondition(), campaignStates),
                new CampaignProcessingReasons(campaignConditions.moderationCondition(),
                        adGroupsProcessingCounter,
                        adGroupsBlGeneratedCounter,
                        adGroupsStoppedCounter,
                        adGroupsActiveCounter),
                new CampaignMoneyReasons(campaignStates, adGroupsActiveCounter)
        )).reasons();

        if (cpmReason.isPresent() && adGroupsActiveCounter.hasActive()) {
            reasons.add(cpmReason.get());
        }

        return SelfStatus.status(GdSelfStatusEnum.STOP_CRIT, new ArrayList<>(reasons));
    }
}
