package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended.SuspendedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class StopOk implements Status {
    private final CampaignStates campaignStates;
    private final SuspendedCounter adGroupsSuspendedCounter;

    public StopOk(CampaignStates campaignState, SuspendedCounter adGroupsSuspendedCounter) {
        this.campaignStates = campaignState;
        this.adGroupsSuspendedCounter = adGroupsSuspendedCounter;
    }

    @Override
    public boolean isValid() {
        final var condition1 = campaignStates.isSuspended() && !campaignStates.isUnarchiving();
        final var condition2 = adGroupsSuspendedCounter.isAllSuspended() && !campaignStates.isSuspended();
        final var condition3 = campaignStates.isUnitsExhausted();

        return condition1 || condition2 || condition3;
    }

    @Override
    public SelfStatus selfStatus() {
        if (campaignStates.isSuspended() && !campaignStates.isUnarchiving()) {
            return SelfStatus.status(GdSelfStatusEnum.STOP_OK, GdSelfStatusReason.CAMPAIGN_SUSPENDED_BY_USER);
        }

        if (adGroupsSuspendedCounter.isAllSuspended()) {
            return SelfStatus.status(GdSelfStatusEnum.STOP_OK, GdSelfStatusReason.CAMPAIGN_ALL_ADGROUPS_SUSPENDED_BY_USER);
        }

        return SelfStatus.status(GdSelfStatusEnum.STOP_OK, GdSelfStatusReason.CAMPAIGN_UNITS_EXHAUSTED);
    }
}
